@echo off

set BATDIR=%~dp0

for /f "tokens=4-5 delims=. " %%i in ('ver') do set VERSION=%%i.%%j

rem Win10 version: 10.0
rem Win8.1 version: 6.3
rem Win8 version: 6.2
if "%version%" == "10.0" goto CHECK_X64
rem if "%version%" == "6.3" goto CHECK_X64
rem if "%version%" == "6.2" goto CHECK_X64
goto NOT_SUPPORTED_OS

:CHECK_X64
if not defined ProgramFiles(x86) goto NOT_SUPPORTED_OS

:CHECK_PNPUTIL
if not exist c:\windows\system32\pnputil.exe goto NO_PNPUTIL

:INSTALL DRIVER
pnputil /add-driver %BATDIR%\Inspiron7490_Panel.inf /install
if ERRORLEVEL 0 goto PNPUTIL_PASS
goto PNPUTIL_FAIL

:NOT_SUPPORTED_OS
exit 0

:PNPUTIL_PASS
rem
rem Set Registry for Inventory
rem
set DV_KEY="HKLM\SOFTWARE\Dell\MUP\Display"
set DV_NAME="DolbyVision"
set DV_VERSION=1.0.0.0

reg add %DV_KEY% /v Product_Name /t REG_SZ /d %DV_NAME% /f
reg add %DV_KEY% /v Product_Version /t REG_SZ /d %DV_VERSION% /f
exit 0

:PNPUTIL_FAIL
exit 1

:NO_PNPUTIL
exit 2
