
/*
  This file used to override standard Read/WriteProcessMemory,
  because i dont trust them. ;-)
  Also, somebody must dump error messages.
*/

#define LOG_RWMEM

int read_memory(HANDLE handle, DWORD addr, BYTE* buf, DWORD size)
{
  DWORD dd;
  int res = ReadProcessMemory(handle,
                              (void*)addr,
                              buf,
                              size,
                              &dd);
  if ((res == 0) || (dd != size))
  {
#ifdef LOG_RWMEM
    log("ERROR: ReadProcessMemory(addr=%08X,size=%08X) failed, GetLastError = %i\n", addr, size, GetLastError());
#endif
    return 0;
  }
  return 1;
} // read_memory()

int write_memory(HANDLE handle, DWORD addr, BYTE* buf, DWORD size)
{
  DWORD dd;
  int res = WriteProcessMemory(handle,
                               (void*)addr,
                               buf,
                               size,
                               &dd);
  if ((res == 0) || (dd != size))
  {
#ifdef LOG_RWMEM
    log("ERROR: WriteProcessMemory(addr=%08X,size=%08X) failed, GetLastError = %i\n", addr, size, GetLastError());
#endif
    return 0;
  }
  return 1;
} // write_memory()

