{$IFDEF DPMI}
{$A+,B-,D+,E-,F-,G+,I-,L+,N+,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0}
{$ELSE}
{$A+,B-,D+,E-,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384,320000,655360}
{$ENDIF}

uses crt, dos, graph;

const
  def_source_file = 'HISTORY.DWB';
  def_dest_file   = '1.BMP';

  font_file   = 'FONT.FNT';

  maxx        = 500;
  maxy        = 300;

  C_MAX       = 1000;

  source_file : string = '';
  dest_file   : string = '';

type
  TBMPHeader = record
    ID               : Word;
    FileSize         : LongInt;
    Reserved         : LongInt;     { 0 }
    DataPos          : LongInt;
    biSize           : LongInt;
    XSize            : LongInt;
    YSize            : LongInt;
    Planes           : Word;        { 1 }
    Bits             : Word;        {1,4,8,24}
    Compression      : LongInt;
    ImageSize        : LongInt;     {in bytes}
    XPelsPerMeter    : LongInt;
    YPelsPerMeter    : LongInt;
    ClrUsed          : LongInt;
    ClrImportant     : LongInt;
  end;

function fmin(a,b:longint):longint;
  begin
    if a<b then fmin:=a else fmin:=b;
  end;
function fmax(a,b:longint):longint;
  begin
    if a>b then fmax:=a else fmax:=b;
  end;
type
  tx = record dt:datetime; time,ver,vir,size:longint; end;
  tl = array[0..maxx-1] of byte;
var
  t : text;
  s,s1,s2,q1,q2 : string;
  j : integer;
  max : integer;
  arr : array[1..C_MAX] of tx;
  r_min,r_max : tx;
  f : file;
  h : tbmpheader;
  p : array[byte] of record b,g,r,x:byte end;
  a : array[0..maxy-1] of ^tl;


procedure putpixel(x,y,c:integer);
  begin
    if (x<0) or (x>=maxx) then exit;
    if (y<0) or (y>=maxy) then exit;
    a[y]^[x]:=c;
  end;

procedure setrgb(c,  r,g,b:integer);
  begin
    p[c].r:=r;
    p[c].g:=g;
    p[c].b:=b;
  end;

procedure line(x1,y1,x2,y2, color : integer); near; assembler;
  var
    count, d_x, d_y, maxx, maxy : word;
    incx, incy : integer;
  asm
    xor ax, ax
    mov d_x, ax
    mov d_y, ax

    mov incx, 1
    mov ax, x2
    sub ax, x1
    jnz @@1
    dec incx
    jmp @@2
@@1:jns @@2
    neg ax
    neg incx
@@2:mov maxx, ax

    mov incy, 1
    mov bx, y2
    sub bx, y1
    jnz @@3
    dec incy
    jmp @@4
@@3:jns @@4
    neg bx
    neg incy
@@4:mov maxy, bx

    mov cx, ax
    cmp ax, bx
    ja @@5
    mov cx, bx

@@5:mov count, cx

@@6:push cx

    push x1
    push y1
    push color
    call putpixel

    mov si, x1
    mov di, y1
    mov cx, count

    mov ax, maxx
    add d_x, ax
    cmp d_x, cx
    jb @@7
    sub d_x, cx
    add si, incx

@@7:mov ax, maxy
    add d_y, ax
    cmp d_y, cx
    jb @@8
    sub d_y, cx
    add di, incy

@@8:mov x1, si
    mov y1, di

    pop cx
    loop @@6
  end;

procedure rect(x1,y1,x2,y2,c:integer);
  begin
    line(x1,y1,x2,y1,c);
    line(x1,y2,x2,y2,c);
    line(x1,y1,x1,y2,c);
    line(x2,y1,x2,y2,c);
  end;

var
  curx,cury : integer;
procedure moveto(x,y:integer);
  begin
    curx:=x;
    cury:=y;
  end;
procedure lineto(x,y,q:integer);
  var  a,b,c,d:integer;
  begin
    for a:=0 to 1 do
    for b:=0 to 1 do
    for c:=0 to 1 do
    for d:=0 to 1 do
    line(curx+a,cury+b,x+c,y+d,q);
    moveto(x,y);
  end;


var
  font : array[char] of array[0..15] of byte;

procedure outtextxy(cx,cy,c:integer;s:string);
  var
    i,x,y : integer;
  begin
    for y := 0 to 15 do
    for i := 1 to length(s) do
    for x := 0 to 7 do
      if font[s[i]][y] and ($80 shr x) <> 0 then
        putpixel(cx+i*8-8+x,cy+y,c);
  end;

procedure help;
  begin
    writeln;
    writeln('syntax:');
    writeln('  WEBCONV [infile[.DWB]] [outfile[.BMP]]');
    halt;
  end;

function addext(s,e:string):string;
  var
    dir : dirstr;
    name : namestr;
    ext : extstr;
  begin
    fsplit(s,dir,name,ext);
    if ext='' then ext:=e;
    addext:=dir+name+ext;
  end;

var
  min_x0,min_y0,max_x0,max_y0:integer;
  min_x1,min_y1,max_x1,max_y1:real;
function realx(x:real):integer;
  begin
    realx:= round(min_x0+(x-min_x1)/(max_x1-min_x1)*(max_x0-min_x0));
  end;
function realy(y:real):integer;
  begin
    realy:= round(max_y0-(y-min_y1)/(max_y1-min_y1)*(max_y0-min_y0));
  end;

var
  i,x,y:integer;
  ox,oy,y0,x0,ny,l0,l : longint;

begin
  writeln('WEBCONV  Dr.WEB History To BMP Convertor  1.00  ');

  for j := 1 to paramcount do
  begin
    s:=paramstr(j);
    if (length(s)=2) and (s[1] in ['-','/']) and (s[2] in ['?','h','H']) then
      help;
    if (pos('.DWB',s)<>0) or (pos('.dwb',s)<>0) then
    begin
      if source_file<>'' then
      begin
        writeln('error -- bad parameter ',s,', source file alredy defined');
        halt;
      end;
      source_file:=s;
      s:='';
    end;
    if (pos('.BMP',s)<>0) or (pos('.bmp',s)<>0) then
    begin
      if dest_file<>'' then
      begin
        writeln('error -- bad parameter ',s,', destination file alredy defined');
        halt;
      end;
      dest_file:=s;
      s:='';
    end;
    if s<>'' then
    if source_file='' then
      source_file:=addext(s,'.DWB')
    else
    if dest_file='' then
      dest_file:=addext(s,'.BMP')
    else
    begin
      writeln('error -- invalid parameter ',s);
      help;
    end;
  end;

  if source_file = '' then source_file := def_source_file;
  if dest_file = '' then dest_file := def_dest_file;

  writeln('- loading font ',font_file);
  assign(f,font_file);
  filemode:=0;
  reset(f,1);
  filemode:=2;
  if ioresult<>0 then
  begin
    writeln('error -- font file not found: ',font_file);
    halt;
  end;
  blockread(f,font,sizeof(font));
  close(f);

  writeln('- allocating ',maxx*maxy div 1024,'k of memory for picture');
  for j := 0 to maxy-1 do
  begin
    if maxavail < maxx then
    begin
      writeln('error -- not enough memory');
      halt;
    end;
    getmem(a[j], maxx);
  end;

  writeln('- reading ',source_file);

  assign(t, source_file);
  reset(t);
  if ioresult<>0 then
  begin
    writeln('error -- source file not found: ',source_file);
    halt;
  end;
  j:=0;
  max := 0;
  while not eof(t) do
  begin
    readln(t,s);
    s1:=copy(s,1,8);
    s2:=copy(s,10,8);
    if pos('vir.',s1)<>0 then delete(s1,pos('vir.',s1),4);
    if pos('vir' ,s1)<>0 then delete(s1,pos('vir' ,s1),3);
    while (s1<>'') and (s1[1] in [#32,#9]) do delete(s1,1,1);
    while (s2<>'') and (s2[1] in [#32,#9]) do delete(s2,1,1);
    while (s1<>'') and (s1[length(s1)] in [#32,#9]) do dec(s1[0]);
    while (s2<>'') and (s2[length(s2)] in [#32,#9]) do dec(s2[0]);
    if s1<>'' then
    if s2<>'' then
    begin
      if (length(s1)=4) and (s1[2]='.') and (length(s2)=8) and
         (s2[3]='.') and (s2[6]='.') then
      begin
        q1:=s1;
        q2:=s2;
        j:=1;
      end else begin
        if j=1 then
        begin
{
          writeln('[',q1,'] [',q2,'] [',s1,'] [',s2,']');
}
          inc(max);
          if max>=C_MAX then
          begin
            writeln('error -- too many entries (',C_MAX,' max)');
            halt;
          end;
          arr[max].dt.year := ord(q2[7])*10+ord(q2[8])-$30*11;
          arr[max].dt.month:= ord(q2[4])*10+ord(q2[5])-$30*11;
          arr[max].dt.day  := ord(q2[1])*10+ord(q2[2])-$30*11;
          arr[max].ver     := ord(q1[1])*100+ord(q1[3])*10+ord(q1[4])-$30*111;
          val(s1, arr[max].vir, j);
          val(s2, arr[max].size, j);
          arr[max].time := arr[max].dt.year*12*31+
                  arr[max].dt.month*31+
                  arr[max].dt.day;
          j:=0;
        end;
      end;
    end;
  end;
  close(t);

  if max<10 then
  begin
    writeln('error -- no entries');
    halt;
  end;

  writeln('  ',max,' entries');

  r_min:=arr[1];
  r_max:=arr[1];
  for j := 2 to max do
  begin
    r_min.time:=fmin(r_min.time,arr[j].time);
    r_min.time:=fmin(r_min.time,arr[j].time);
    r_min.ver :=fmin(r_min.ver ,arr[j].ver );
    r_min.vir :=fmin(r_min.vir ,arr[j].vir );
    r_min.size:=fmin(r_min.size,arr[j].size);
    r_max.time:=fmax(r_max.time,arr[j].time);
    r_max.ver :=fmax(r_max.ver ,arr[j].ver );
    r_max.vir :=fmax(r_max.vir ,arr[j].vir );
    r_max.size:=fmax(r_max.size,arr[j].size);
  end;

  writeln('- generating picture (',maxx,'x',maxy,')');

  fillchar(h, sizeof(h), 0);
  fillchar(p, sizeof(p), 0);
  for j := 0 to maxy-1 do
    fillchar(a[j]^,maxx,1);

  h.ID := $4D42;
  h.filesize := sizeof(h) + sizeof(p) + maxx * maxy;
  h.datapos  := sizeof(h) + sizeof(p);
  h.biSize   := $28;
  h.xsize    := maxx;
  h.ysize    := maxy;
  h.planes   := 1;
  h.bits     := 8;
  h.imagesize:= maxx * maxy;
  h.clrused  := 256;
  h.clrimportant := 256;

  min_x0:=0+1;
  min_y0:=0+1;
  max_x0:=maxx-2;
  max_y0:=maxy-2;
  min_x1:=r_min.time;
  max_x1:=r_max.time;

  setrgb(1, 0,0,0);

  for i := 0 to 15 do
    setrgb(100+i, $b0-(i+5)*12,$b0-(i+3)*12,$b0-(i+5)*12);
  l0 := -1;
  ny:=0;
  for x := min_x0 to max_x0 do
  for y := min_y0 to max_y0 do
  begin
    l := round(  min_x1+(x-min_x0)/(max_x0-min_x0)*(max_x1-min_x1) );
    l := (l - r_min.time) div (31*12);
    {if (y>min_y0+16+4) or ( (x+y) mod 3=0 ) then}
    putpixel(x,y,101+l);

    if l<>l0 then
    begin
      l0:=l;
      inc(ny);
      if ny=2 then
        x0:=x-min_x0;
    end;
  end;

  setrgb(6, $ff,$ff,$aa);
  for i := 0 to ny-1 do
  begin
    str( 1900+(r_min.time div (31*12))+i ,s);
    outtextxy(min_x0+round(i*x0)+2,
              min_y0+2,
              6,
              s);
  end;

  inc(min_y0,16);
  {
  dec(max_y0,5);
  inc(min_x0,5);
  }

  {
  setrgb(1, 0,$aa,0);
  rect(0,0,maxx-1,maxy-1, 1);
  }

  {
  setrgb(2, $c0,$c0,$c0);
  line(0+10,maxy-20,maxx-10,maxy-20, 2);
  line(0+20,10,0+20,maxy-10, 2);
  }

  min_y1:=r_min.ver;
  max_y1:=r_max.ver;
  setrgb(3, 0,$aa,$c0);
  setrgb(7, 0,0,0);
  i:=0;
  x0:=-1;
  for j := 1 to max do
  begin
    x:=realx(arr[j].time);
    y:=realy(arr[j].ver);
    if j>1 then if arr[j].ver div 100 <> arr[j-1].ver div 100 then i:=0;
    if (i=0) or (j=max) then begin
      moveto(x,y);
      i:=1;

      if x0<>-1 then
      begin
        x0:=(x0+ox) div 2;
        y0:=(y0+oy) div 2+16;
        outtextxy(x0-16,y0-4,7,chr($30+arr[j-1].ver div 100)+'.xx');
      end;

      x0:=x;
      y0:=y;
    end else
      lineto(x,y,3);
    ox:=x;
    oy:=y;
  end;

  min_y1:=r_min.size;
  max_y1:=r_max.size;
  setrgb(5, 0,$ff,$aa);
  for j := 1 to max do
  begin
    x:=realx(arr[j].time);
    y:=realy(arr[j].size);
    if (j=1) then
      moveto(x,y)
    else
      lineto(x,y,5);
  end;


  min_y1:=r_min.vir;
  max_y1:=r_max.vir;
  setrgb(4, $ff,0,0);
  for j := 1 to max do
  begin
    x:=realx(arr[j].time);
    y:=realy(arr[j].vir);
    if j=1 then
      moveto(x,y)
    else
      lineto(x,y,4);
  end;

  setrgb(8, 0,0,0);
  for x := max_x0-100-4 to max_x0-4 do
  for y := max_y0-70-4 to max_y0-4 do
    if ((x+y) mod 3)=0 then
      putpixel(x,y,8);

  str(r_max.ver,s);
  outtextxy(max_x0-100+3,max_y0-70+4,3,'ver: '+s[1]+'.'+s[2]+s[3]);
  str(r_max.size,s);
  outtextxy(max_x0-100+3,max_y0-50+4,5,'size:'+s);
  str(r_max.vir,s);
  outtextxy(max_x0-100+3,max_y0-30+4,4,'vir: '+s);


  writeln('- writing ',dest_file,' (',h.filesize div 1024,'k)');

  assign(f, dest_file);
  rewrite(f,1);
  blockwrite(f, h, sizeof(h));
  blockwrite(f, p, sizeof(p));
  for j := maxy-1 downto 0 do
    blockwrite(f, a[j]^, maxx);
  close(f);


end.
