
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <io.h>
#include <string.h>

#include "dearmor.cpp"

void main(int argc, char* argv[])
{
  printf("PGP2TXT  version 1.00  (x) 2000 Z0MBiE  http://z0mbie.cjb.net\n");

  if (argc!=2)
  {
    printf("\nconvert public pgp keyfile (binary or ascii) into text format (dump E&N)\ntested on PGP 2.6.3ia\n\n"\
           "syntax:\n  PGP2TXT <public-pgp-key-file>\n");
    exit(0);
  }

  FILE*f=fopen(argv[1],"rb");
  if (f==NULL)
  {
    printf("***ERROR***: can't open file %s\n", argv[1]);
    exit(0);
  }
  printf("- processing %s\n", argv[1]);
  int isize=filelength(fileno(f));
  char* ibuf=(char*)malloc(isize+1);
  ibuf[isize]=0;
  printf("- reading %i bytes\n", isize);
  fread(ibuf, 1,isize, f);
  fclose(f);

  char *c=ibuf;
  char *x=0, *maxx=0;

  if ((unsigned char)*c&0x80)
  {
    printf("- found binary pgp key at startup\n");
    x = c;
    maxx = c+isize;
  }
  else
  {
    while (c && *c)
    {
//    if (c[0]<32 && c[1]=='m' && c[2]=='Q')
      if ((!(c[0]&0x80))&&(strchr(c,13)-c==64))
      {
        printf("- found ascii pgp key at offset 0x%08X\n", c - ibuf);

        char* obuf=(char*)malloc((isize*3+3)/4);
        int osize;

        darmor_buffer(c, obuf, &osize);

        char fname[512];
        strcpy(fname, argv[1]);
        if (strrchr(fname,'.'))
          strcpy(strrchr(fname,'.'),".bin");
        else
          strcat(fname,".bin");

        printf("- writing %s, %i bytes\n", fname, osize);

        f=fopen(fname,"wb");
        if (!f)
        {
          printf("***ERROR***: cant create file %s\n",fname);
          exit(0);
        }
        fwrite(obuf, 1,osize, f);
        fclose(f);

        x=obuf;
        maxx=obuf+osize;

        break;
      }
      c++;
    }
  }

  if (!x)
  {
    printf("***ERROR***: no ascii pgp key found in your fuckin file\n");
    exit(0);
  }

  printf("- processing data\n");

  while (x<maxx)
  {
    int i=*x++;
    if (i&0x80)
    {
      int len=1<<(i&3);
      if (len==1) { len=*x; x+=1; } else
      if (len==2) { len=*(short*)x; x+=2; len=((len&0xFF)<<8)|((len&0xFF00)>>8); } else
      if (len==4) { len=*(long*)x; x+=4; len=((len&0xFF)<<24)|((len&0xFF00)<<8)|((len&0xFF0000)>>8)|((len&0xFF000000)>>24); } else
      if (len==8) len=0;
      int typ=(i>>2)&0x0F;
      printf("- CTB type=%i%i%i%ib/0x%02X, len=%i\n", (i>>5)&1,(i>>4)&1,(i>>3)&1,(i>>2)&1, typ, len);
      switch (typ)
      {
        case 0x02: printf("  secret-key-encrypted (signature) packet\n");
                   break;
        case 0x06: {
                   char* x0=x;

                   printf("  public key certificate\n");
                   printf("  version=%i\n",*x0++);
                   printf("  timestamp=%08X\n",*(unsigned long*)x0); x0+=4;
                   printf("  validity period=%i days (0=forever)\n", *(unsigned short*)x0); x0+=2;
                   printf("  algorithm=%i (1=RSA)\n",*x0++);

                   char fname[512];
                   strcpy(fname, argv[1]);
                   if (strrchr(fname,'.'))
                     strcpy(strrchr(fname,'.'),".txt");
                   else
                     strcat(fname,".txt");

                   f=fopen(fname,"wb");
                   if (!f)
                   {
                     printf("***ERROR***: cant create file %s\n",fname);
                     exit(0);
                   }
                   printf("- writing %s\n", fname);

                   fprintf(f,"\ngenerated by PGP2TXT utility, http://z0mbie.cjb.net\n\n");
                   fprintf(f,"dump of file %s\n\n",argv[1]);

                   unsigned short l=*(unsigned short*)x0; x0+=2;
                   l=((l&0xFF)<<8)|((l&0xFF00)>>8);
                   printf("  N, length=%i bits\n",l);

                   fprintf(f," modulus n =");
                   int lcount=0;
                   while ((short)l>0)
                   {
                     fprintf(f," %04X",*(unsigned short*)x0); x0+=2; l-=16;
                     lcount=(lcount+1)&7;
                     if (!lcount) fprintf(f,"\n            ");
                   }
                   fprintf(f,"\n");

                   l=*(unsigned short*)x0; x0+=2;
                   l=((l&0xFF)<<8)|((l&0xFF00)>>8);
                   printf("  E, length=%i bits\n",l);

                   fprintf(f,"exponent e =");
                   lcount=0;
                   while ((short)l>0)
                   {
                     fprintf(f," %04X",(*(unsigned short*)x0) & (l>=16?0xFFFF:( (1<<l)-1 )) );
                     x0+=2; l-=16;
                     lcount=(lcount+1)&7;
                     if (!lcount) fprintf(f,"\n            ");
                   }
                   fprintf(f,"\n");

                   fclose(f);

                   break;
                   }
        case 0x0D:
        {
           char s[256];
           memcpy(s, x, len);
           s[len]=0;
           printf("  user id packet, [%s]\n", s);
           break;
        }
        default: printf("  unknown type\n");
      }

      x+=len;
    }
    else
    {
      printf("- CTB not found (0x%02X)\n", i&255);
      exit(0);
    }
  }
  printf("- key data processed, exiting\n");

}
