
; Real Permutating Engine (RPME)
; version 2.00
;
; ENGINE DEMO
; ~~~~~~~~~~~
;
; program action:
;   continuously execute 3k of permutable code,
;   save codeNNNN.bin file on each execution
; code action:
;   permutate itself by calling RPME

; files: (raw 32-bit code)
;   code0000.bin   initial code (not permutated)
;   code0001.bin   permutated once
;   ...
;   code0003.bin   (cycle #3 only) randomize empty space
;   ...
;   code0005.bin   (cycle #5 only) remove small code blocks,
;                  "collect" code into one block w/o random jmps inside
;   ...
;   code0007.bin   (cycle #7 only) jmp-prob = 3 (default=5)
;   ...
;   code0009.bin   (cycle #9 only) jmp-prob = 100
;   ...

; source files:
;   1.asm          this file
;   console.inc    console io stuff
;   fioexlow.inc   file io stuff
;   lde32bin.inc   LDE32 engine (disassembler)
;   rpme-krn.inc   RPME kernel
;   rpme-mut.inc   RPME mutator


CODESIZE                equ     32768
MAXMEM                  equ     80000h  ;512k

callW                   macro   x
                        extrn   x:PROC
                        call    x
                        endm

pusho                   macro   abc
                        local   @@t
                        call    @@t
                        jmp     abc
@@t:
                        endm

                        p386
                        model   flat

                        .data

randseed                dd      12345678h
permcount               dd      0

filename                db      'code0000.bin',0
filenameC               equ     byte ptr $-6

; ---------------------------------------------------------------------------
ibuf:

permutate:              pusha

                        mov     mem_count, 0

                        push    offset ldetbl
                        call    disasm_init

; ---------------------------------------------------------------------------

                        pusho   my_malloc
                        pusho   my_disasm
                        pusho   my_mutate
                        pusho   my_rnd

; ---------------------------------------------------------------------------

                        push    5               ; jmp-prob

                        cmp     permcount, 5
                        jne     k1
                        pop     eax             ; no jmps
                        push    0

k1:
                        cmp     permcount, 7
                        jne     k2
                        pop     eax
                        push    3
k2:

                        cmp     permcount, 9
                        jne     k3
                        pop     eax
                        push    100

k3:

; ---------------------------------------------------------------------------

                        push    0               ; extrelfix

; ---------------------------------------------------------------------------

                        push    0CCh            ; ofiller

                        cmp     permcount, 3
                        jne     j1

                        pop     eax
                        push    -1              ; ofiller - transparent

                        lea     edi, obuf
                        mov     ecx, CODESIZE
j2:                     push    256
                        push    12345678h
                        call    my_rnd
                        add     esp, 8

                        stosb
                        loop    j2

j1:

; ---------------------------------------------------------------------------

                        call    $+5
                        pop     eax
                        cmp     eax, offset ibuf+CODESIZE
                        jb      c1

                        push    0
                        push    CODESIZE
                        push    offset ibuf
                        push    0
                        push    CODESIZE
                        push    offset obuf

                        jmp     c2

c1:                     push    0
                        push    CODESIZE
                        push    offset obuf
                        push    0
                        push    CODESIZE
                        push    offset ibuf
c2:

; ---------------------------------------------------------------------------

                        push    12345678h
                        call    engine
                        add     esp, 14*4

                        mov     [esp+7*4], eax  ; exitcode

                        add     al, '0'
                        call    dump_al         ; external-call

                        popa
                        ret     ; permutate

my_malloc:              mov     eax, [esp+8]
                        add     eax, mem_count
                        cmp     eax, MAXMEM
                        jae     @@1
                        xchg    mem_count, eax
                        add     eax, offset mem_buf
                        retn
@@1:                    xor     eax, eax
                        ret

my_disasm:              push    dword ptr [esp+8]
                        push    offset ldetbl
                        call    disasm_main
                        retn

my_mutate:              jmp     mutate

my_rnd:                 mov     eax, randseed
                        imul    eax, 214013
                        add     eax, 2531011
                        mov     randseed, eax
                        shr     eax, 16
                        imul    eax, [esp+8]
                        shr     eax, 16
                        retn


engine:
include                 ..\..\RPME\rpme-krn.inc ; engine:
mutate:
include                 ..\..\RPME\rpme-mut.inc ; mutate:

include                 lde32bin.inc            ; LDE32

isize0                  equ     $-ibuf

                        org     ibuf+CODESIZE

; ---------------------------------------------------------------------------

ldetbl                  db      2048 dup (?)

obuf                    db      CODESIZE dup (?)

mem_count               dd      ?
mem_buf                 db      MAXMEM dup (?)

                        .code
start:
                        callW   GetTickCount

                        mov     randseed, eax
                        call    dump_hexdword
                        call    dump_crlf

                        lea     edx, filename
                        call    fcreate
                        xchg    ebx, eax
                        lea     edx, ibuf
                        mov     ecx, isize0
                        call    fwrite
                        call    fclose

cycle:
                        inc     permcount

                        lea     edx, filenameC
@@9:                    inc     byte ptr [edx]
                        cmp     byte ptr [edx], '9'
                        jbe     @@0
                        mov     byte ptr [edx], '0'
                        dec     edx
                        jmp     @@9
@@0:

                        test    permcount, 1
                        jz      @@x

                        lea     edi, obuf
                        mov     ecx, CODESIZE
                        mov     al, 0CCh
                        rep     stosb

                        lea     ebp, obuf
                        call    permutate

                        loopz   $+2

                        jmp     @@y

@@x:
                        lea     edi, ibuf
                        mov     ecx, CODESIZE
                        mov     al, 0CCh
                        rep     stosb

                        lea     ebp, ibuf
                        call    near ptr obuf

                        loopz   $+2
@@y:

                        or      eax, eax
                        jnz     exit

                        lea     edx, filename
                        call    fcreate
                        xchg    ebx, eax
                        mov     edx, ebp
                        mov     ecx, CODESIZE
                        call    fwrite
                        call    fclose

                        jmp     cycle

exit:                   mov     eax, permcount

                        push    -1
                        callW   ExitProcess

include                 console.inc
include                 fioexlow.inc

                        end     start
