
// AVAILABLE MACROS:                 ARGUMENTS:                   \r,\n-->CR,LF:
//
// 1 xorstr                            (char* dst, char* src)                 -
// 4 virstr_hash32_<c|v>[_new]         (DWORD var_name, "string")             -
// 2 virstr_callpop[_new]              (char* var_name, "string")             -
// 8 virstr_<stosb|stosd>[_xor][_new]  (char* var_name, "string")             +
//                          |     `--- declare var_name
//                          `--------- simply encrypt string
// 4 virstr_<stosb|stosd>_xored[_new]  (char* var_name, "string1", "string2") +
// 2 virstr_stosd_xor_key[_new]        (char* var_name, "string",             +
//                                      const keyC, DWORD keyV)
//

#ifndef __VIRSTR_HPP__
#define __VIRSTR_HPP__

//#define MIN(a,b)        ((a)<(b)?(a):(b))
//#define MAX(a,b)        ((a)>(b)?(a):(b))
#define ALIGN4(x)         (((x)+3)&(~3))
#define VIRSTR_INC        virstr.inc      // <-- where asm macros are located

#define xorstr(dst_pstr, src_pstr)                              \
        {                                                       \
          char* __virstr_temp__d = dst_pstr;                    \
          char* __virstr_temp__s = src_pstr;                    \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                mov     esi, __virstr_temp__s                 ; \
                cld                                           ; \
                asm_xorstr                                    ; \
          }                                                     \
        }

#define virstr_hash32_c_new(out, qstr)                          \
          unsigned long out;                                    \
          virstr_hash32_c(out, qstr);

// we use 'out = _EAX' because variable can have the same name as register.

#define virstr_hash32_c(out, qstr)                              \
        {                                                       \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                hash32_str_c qstr                             ; \
                mov eax, hash                                 ; \
          }                                                     \
          out = _EAX;                                           \
        }

#define virstr_hash32_v_new(out, pstr)                          \
          unsigned long out;                                    \
          virstr_hash32_v(out, pstr);

#define virstr_hash32_v(out, pstr)                              \
        {                                                       \
          char* __virstr_temp__ = pstr;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov esi, __virstr_temp__                      ; \
                hash32_str_v                                  ; \
          }                                                     \
          out = _EAX;                                           \
        }

#define virstr_callpop_new(out, qstr)                           \
          const char* out;                                      \
          virstr_callpop(out, qstr);

#define virstr_callpop(out, qstr)                               \
        {                                                       \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                push_str qstr                                 ; \
                pop     eax                                   ; \
          }                                                     \
          out = (char*)_EAX;                                    \
        }

#define virstr_stosb_new(out, qstr)                             \
          char out[ sizeof(qstr) ];                             \
          virstr_stosb(out, qstr);

#define virstr_stosb(out, qstr)                                 \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                cld                                           ; \
                stos_str 1, 0, qstr                           ; \
          }                                                     \
        }

#define virstr_stosb_xor_new(out, qstr)                         \
          char out[ sizeof(qstr) ];                             \
          virstr_stosb_xor(out, qstr);

#define virstr_stosb_xor(out, qstr)                             \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                cld                                           ; \
                stos_str 1, 1, qstr                           ; \
          }                                                     \
        }

#define virstr_stosd_new(out, qstr)                             \
          char out[ALIGN4(sizeof(qstr))];                       \
          virstr_stosd(out, qstr);

#define virstr_stosd(out, qstr)                                 \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                cld                                           ; \
                stos_str 4, 0, qst                            ; \
          }                                                     \
        }

#define virstr_stosd_xor_new(out, qstr)                         \
          char out[ALIGN4(sizeof(qstr))];                       \
          virstr_stosd_xor(out, qstr);

#define virstr_stosd_xor(out, qstr)                             \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                cld                                           ; \
                stos_str 4, 1, qstr                           ; \
          }                                                     \
        }

#define virstr_stosb_xored_new(out, qstr1, qstr2)               \
          char out[ sizeof(qstr1) ];                            \
          virstr_stosb_xored(out, qstr1, qstr2);

#define virstr_stosb_xored(out, qstr1, qstr2)                   \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                cld                                           ; \
                stos_str_xored 1, qstr1, qstr2                ; \
          }                                                     \
        }

#define virstr_stosd_xored_new(out, qstr1, qstr2)               \
          char out[ ALIGN4(sizeof(qstr1)) ];                    \
          virstr_stosd_xored(out, qstr1, qstr2);

#define virstr_stosd_xored(out, str1, str2)                     \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                cld                                           ; \
                stos_str_xored 4, str1, str2                  ; \
          }                                                     \
        }

#define virstr_stosd_xor_key_new(out, qstr, keyC, keyV)         \
          char out[ALIGN4(sizeof(qstr))];                       \
          virstr_stosd_xor_key(out, qstr, keyC, keyV);

#define virstr_stosd_xor_key(out, qstr, keyC, keyV)             \
        {                                                       \
          char* __virstr_temp__d = out;                         \
          unsigned long __virstr_temp__v = keyV;                \
          asm                                                   \
          {                                                     \
                include VIRSTR_INC                            ; \
                mov     edi, __virstr_temp__d                 ; \
                mov     eax, __virstr_temp__v                 ; \
                cld                                           ; \
                stos_str 4, 1, qstr, keyC                     ; \
          }                                                     \
        }

#endif // __VIRSTR_HPP__
