
// VIRSTR library example.
// to compile: bcc32 example

#include <stdio.h>
#include "virstr.hpp"

int main()
{
  virstr_stosd_xor_new(s, "find me in the executable");
  printf("hidden string = %s\n", s);

  for(unsigned k=0x12345670; k<=0x1234567F; k++)
  {
    // try to build string using some key (it must match predefined value)
#define HIDDEN_STRING "c:\winnt\kernel32.dll"
    static char s[260];
    virstr_stosd_xor_key(s, HIDDEN_STRING, 0x12345678, k);
    // verify string using hashes
    virstr_hash32_c_new(h0, HIDDEN_STRING); // h0 == precalculated hash
    virstr_hash32_v_new(h1, s);             // h1 == current hash
    printf("key=%08X h0=%08X h1=%08X s='%s' result=%s\n",
      k, h0, h1, s, h0==h1?"OK":"FAILED");
  }
}//main
