
calchash                macro   procname
                        hash = 0
                        irpc    c, <procname>
                        hash = ((hash shl 7) and 0FFFFFFFFh) or (hash shr (32-7))
                        hash = hash xor "&c"
                        endm
                        endm

callK32                 macro   procname
                        calchash procname
                        push    hash
                        call    k32man_get_proc_address
                        call    eax
                        endm

callREG                 macro   procname
                        calchash procname
                        push    hash
                        call    advapi_get_proc_address
                        call    eax
                        endm

callWSK                 macro   procname
                        calchash procname
                        push    hash
                        call    wsock_get_proc_address
                        call    eax
                        endm

pusho                   macro   lbl             ; kind of 'push offset lbl'
                        local   __tmp
                        call    __tmp
                        jmp     lbl
__tmp:                  endm

seh_init                macro
                        pusha
                        call    __seh_init
__seh_error:            mov     esp, [esp+8]
                        pop     dword ptr fs:[0]
                        pop     ecx
                        popa
                        stc
                        jmp     __seh_exit
__seh_init:             push    dword ptr fs:[0]
                        mov     fs:[0], esp
                        endm

seh_done                macro
                        pop     dword ptr fs:[0]
                        add     esp, 4+32 ; CF=0
__seh_exit:             endm

pusha_eax               =       (dword ptr 7*4)
pusha_ecx               =       (dword ptr 6*4)
pusha_edx               =       (dword ptr 5*4)
pusha_ebx               =       (dword ptr 4*4)
pusha_esp               =       (dword ptr 3*4)
pusha_ebp               =       (dword ptr 2*4)
pusha_esi               =       (dword ptr 1*4)
pusha_edi               =       (dword ptr 0*4)

popa_eax                =       (dword ptr 7*4)
popa_ecx                =       (dword ptr 6*4)
popa_edx                =       (dword ptr 5*4)
popa_ebx                =       (dword ptr 4*4)
popa_esp                =       (dword ptr 3*4)
popa_ebp                =       (dword ptr 2*4)
popa_esi                =       (dword ptr 1*4)
popa_edi                =       (dword ptr 0*4)

mz_struc                struc
mz_id                   dw      ?               ; MZ/ZM
mz_last512              dw      ?
mz_num512               dw      ?
mz_relnum               dw      ?
mz_hdrsize              dw      ?               ; in PAR
mz_minmem               dw      ?
mz_maxmem               dw      ?
mz_ss                   dw      ?
mz_sp                   dw      ?
mz_csum                 dw      ?               ; 0
mz_ip                   dw      ?
mz_cs                   dw      ?
mz_relptr               dw      ?
mz_ovrnum               dw      ?               ; 0
                        db      32 dup (?)
mz_neptr                dd      ?
                        ends

pe_struc                struc
pe_id                   dd      ?       ; 00 01 02 03  pe00
pe_cputype              dw      ?       ; 04 05        14c..14e: i386..i586
pe_numofobjects         dw      ?       ; 06 07
pe_datetime             dd      ?       ; 08 09 0a 0b  date/time
pe_cofftableptr         dd      ?       ; 0c 0d 0e 0f
pe_cofftablesize        dd      ?       ; 10 11 12 13
pe_ntheadersize         dw      ?       ; 14 15
pe_exeflags             dw      ?       ; 16 17
                        ; ntheader
pe_ntheader_id          dw      ?       ; 18 19
pe_linkmajor            db      ?       ; 19
pe_linkminor            db      ?       ; 1a
pe_sizeofcode           dd      ?       ; 1c 1d 1e 1f
pe_sizeofinitdata       dd      ?       ; 20 21 22 23
pe_sizeofuninitdata     dd      ?       ; 24 25 26 27
pe_entrypointrva        dd      ?       ; 28 29 2a 2b
pe_baseofcoderva        dd      ?       ; 2c 2d 2e 2f
pe_baseofdatarva        dd      ?       ; 30 31 32 33
pe_imagebase            dd      ?       ; 34 35 36 37    align: 64k
pe_objectalign          dd      ?       ; 39 30 3a 3b  256n > power2 > 512
pe_filealign            dd      ?       ; 3c 3d 3e 3f   64k > power2 > 512
pe_osmajor              dw      ?       ; 40 41
pe_osminor              dw      ?       ; 42 43
pe_usermajor            dw      ?       ; 44 45
pe_userminor            dw      ?       ; 46 47
pe_subsysmajor          dw      ?       ; 48 49
pe_subsysminor          dw      ?       ; 4a 4b
                        dd      ?       ; 4c 4d 4e 4f
pe_imagesize            dd      ?       ; 50 51 52 53  align: objectalign
pe_headersize           dd      ?       ; 54 55 56 57  dosh+peh+objecttable
pe_checksum             dd      ?       ; 58 59 5a 5b  0
pe_subsystem            dw      ?       ; 5c 5d
pe_dllflags             dw      ?       ; 5e 5f
pe_stackreservesize     dd      ?       ; 60 61 62 63
pe_stackcommitsize      dd      ?       ; 64 65 66 67
pe_heapreservesize      dd      ?       ; 68 69 6a 6b
pe_heapcommitsize       dd      ?       ; 6c 6d 6e 6f
pe_loaderflags          dd      ?       ; 70 71 72 73
pe_numofrvaandsizes     dd      ?       ; 74 75 76 77   =10h
                        ; rva/sizes
pe_rvasizes             label   dword
pe_exporttablerva       dd      ?       ; 78 79 7a 7b
pe_exporttablesize      dd      ?       ; 7c 7d 7e 7f
pe_importtablerva       dd      ?       ; 80 81 82 83
pe_importtablesize      dd      ?       ; 84 85 86 87
pe_resourcetablerva     dd      ?       ; 88 89 8a 8b
pe_resourcetablesize    dd      ?       ; 8c 8d 8e 8f
pe_exceptiontablerva    dd      ?       ; 90 91 92 93
pe_exceptiontablesize   dd      ?       ; 94 95 96 97
pe_securitytablerva     dd      ?       ; 98 99 9a 9b
pe_securitytablesize    dd      ?       ; 9c 9d 9e 9f
pe_fixuptablerva        dd      ?       ; a0 a1 a2 a3
pe_fixuptablesize       dd      ?       ; a4 a5 a6 a7
pe_debugtablerva        dd      ?       ; a8 a9 aa ab
pe_debugtablesize       dd      ?       ; ac ad ae af
pe_imgdescrrva          dd      ?       ; b0 b1 b2 b3
pe_imgdescrsize         dd      ?       ; b4 b5 b6 b7
pe_machinerva           dd      ?       ; b8 b9 ba bb
pe_machinesize          dd      ?       ; bc bd be bf
pe_tlsrva               dd      ?       ; c0 c1 c2 c3
pe_tlssize              dd      ?       ; c4 c5 c6 c7
pe_loadcfgrva           dd      ?       ; c8 c9 ca cb
pe_loadcfgsize          dd      ?       ; cc cd ce cf
                        dq      ?       ; d0 d1 d2 d3 d4 d5 d6 d7
pe_iattablerva          dd      ?       ; d8 d9 da db
pe_iattablesize         dd      ?       ; dc dd de df
                        dq      ?       ; e0 e1 e2 e3 d4 e5 e6 e7
                        dq      ?       ; e8 e9 ea eb ec ed ee ef
                        dq      ?       ; f0 f1 f2 f3 f4 f5 f6 f7
                        ends

oe_struc                struc
oe_name                 db      8 dup (?);00 01 02 03 04 05 06 07
oe_virt_size            dd      ?       ; 08 09 0a 0b
oe_virt_rva             dd      ?       ; 0c 0d 0e 0f  align: objectalign
oe_phys_size            dd      ?       ; 10 11 12 13
oe_phys_offs            dd      ?       ; 14 15 16 17  align: filealign
oe_xxx                  dd      ?       ; for obj file
                        dd      ?       ; --//--
                        dd      ?       ; --//--
oe_flags                dd      ?        ; 24 25 26 27
                        ends

ex_struct               struct
ex_flags                dd      ?       ; 00 01 02 03
ex_datetime             dd      ?       ; 04 05 06 07
ex_major_ver            dw      ?       ; 08 09
ex_minor_ver            dw      ?       ; 0A 0B
ex_namerva              dd      ?       ; 0C 0D 0E 0F
ex_ordinalbase          dd      ?       ; 10 11 12 13
ex_numoffunctions       dd      ?       ; 14 15 16 17
ex_numofnamepointers    dd      ?       ; 18 19 1A 1B
ex_addresstablerva      dd      ?       ; 1C 1D 1E 1F
ex_namepointersrva      dd      ?       ; 20 21 22 23
ex_ordinaltablerva      dd      ?       ; 24 25 26 27
                        ends

x_stosd_first           macro
                        _eax    = 0
                        xor     eax, eax
                        endm

x_stosd_next            macro   t, x
                        if      t eq 0
                        sub     eax, _eax - x
                        endif
                        if      (t eq 1) or (t eq 3)
                        xor     eax, _eax xor x
                        endif
                        if      t eq 2
                        add     eax, x - _eax
                        endif
                        _eax = x
                        stosd
                        endm

x_stosd                 macro   x
                          x_stosd_first
                          j = 0
                          s = 0
                          t = 0
                          irpc    c, <x>
                            k = "&c"
                            if      k eq "~"    ; zero
                              k = 0
                            endif
                            if      k eq "|"    ; space
                              k = 32
                            endif
                            if      k eq ""    ; cr
                              k = 13
                            endif
                            if      k eq ""    ; lf
                              k = 10
                            endif
                            j = j + k shl s
                            s = s + 8
                            if s eq 32
                              x_stosd_next t,j
                              t = t + 1
                              if t eq 4
                                t = 0
                              endif
                              j = 0
                              s = 0
                            endif   ; i eq 4
                          endm    ; irpc
                          if s ne 0
                            j = (j + 12345678h shl s) and 0ffffffffh
                            x_stosd_next t,j
                          endif
                        endm    ; x_stosd

x_push_first            macro   r
                        xor     r, r
                        _reg = 0
                        endm

x_push_next             macro   q, r, x
                        if q eq 0
                        sub     r, _reg - x
                        endif
                        if (q eq 1) or (q eq 3)
                        xor     r, _reg xor x
                        endif
                        if q eq 2
                        add     r, x - _reg
                        endif
                        push    r
                        _reg = x
                        endm

x_push                  macro   r, x
                        x_push_first r
                        _xsize = 0
                        l       = 0
                        irpc    c, <x>
                        l       = l + 1
                        endm
                        j = 0
                        s = 0
                        l0 = l
                        if (l0 and 3) ne 0
                        j = j shl 8 + "x"
                        s = s + 8
                        l0 = l0 + 1
                        endif
                        if (l0 and 3) ne 0
                        j = j shl 8 + "y"
                        s = s + 8
                        l0 = l0 + 1
                        endif
                        if (l0 and 3) ne 0
                        j = j shl 8 + "z"
                        s = s + 8
                        l0 = l0 + 1
                        endif
                        q = 0
                        i       = l - 1
                        irpc    c1, <x>
                          t       = 0
                          irpc    c, <x>
                            k = "&c"
                            if      k eq "~"    ; zero
                              k = 0
                            endif
                            if      k eq "|"    ; space
                              k = 32
                            endif
                            if      k eq ""    ; cr
                              k = 13
                            endif
                            if      k eq ""    ; lf
                              k = 10
                            endif
                            if t eq i
                              j = j shl 8
                              if k ne 0
                              j = j + k
                              endif
                              s = s + 8
                              if s eq 32
                                _xsize = _xsize + 4
                                x_push_next q,r,j
                                q = q + 1
                                if q eq 4
                                  q = 0
                                endif
                                s = 0
                                j = 0
                              endif
                              exitm
                            endif
                            t     = t + 1
                          endm l irpc
                          i = i - 1
                        endm ; irpc
                        if s ne 0
                          error
                        endif
                        endm ; x_push

x_pop                   macro
                        lea     esp, [esp + _xsize]
                        endm

OPEN_EXISTING           equ     3
CREATE_ALWAYS           equ     2
GENERIC_READ            equ     80000000h
GENERIC_WRITE           equ     40000000h
FILE_SHARE_READ         equ     00000001h
FILE_SHARE_WRITE        equ     00000002h
FILE_ATTRIBUTE_NORMAL   equ     00000080h
FILE_BEGIN              equ     0
FILE_END                equ     2

ff_struc                struc                   ; win32 "searchrec" structure
ff_attr                 dd      ?
ff_time_create          dd      ?,?
ff_time_lastaccess      dd      ?,?
ff_time_lastwrite       dd      ?,?
ff_size_hi              dd      ?
ff_size                 dd      ?
                        dd      ?,?
ff_fullname             db      260 dup (?)
ff_shortname            db      14 dup (?)
                        ends

DRIVE_FIXED             equ     3
DRIVE_REMOTE            equ     4

MACROSIZE               macro   sz
                        if      sz ge 100000
                        db      (sz / 100000) mod 10 + '0'
                        endif
                        if      sz ge  10000
                        db      (sz /  10000) mod 10 + '0'
                        endif
                        if      sz ge   1000
                        db      (sz /   1000) mod 10 + '0'
                        endif
                        if      sz ge    100
                        db      (sz /    100) mod 10 + '0'
                        endif
                        if      sz ge     10
                        db      (sz /     10) mod 10 + '0'
                        endif
                        db      (sz /      1) mod 10 + '0'
                        endm
                        