
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define ARG1_MIN         0
#define ARG1_MAX         3
#define ARG1_STEP        1

#define ARG2_MIN         0
#define ARG2_MAX         31
#define ARG2_STEP        1

unsigned long rol_add_hash(unsigned long arg, char* p)
{
  unsigned long h;
  char* c;

  h = 0;
  while(*p)
  {
    h = (h << arg) | (h >> (32-arg));
    h += (unsigned char)p[0];
    p++;
  }

  return h;
}
unsigned long rol_sub_hash(unsigned long arg, char* p)
{
  unsigned long h;
  char* c;

  h = 0;
  while(*p)
  {
    h = (h << arg) | (h >> (32-arg));
    h -= (unsigned char)p[0];
    p++;
  }

  return h;
}

unsigned long rol_xor_hash(unsigned long arg, char* p)
{
  unsigned long h;
  char* c;

  h = 0;
  while(*p)
  {
    h = (h << arg) | (h >> (32-arg));
    h ^= (unsigned char)p[0];
    p++;
  }

  return h;
}

unsigned long crc_hash(unsigned long arg, char* data)
{
  unsigned char* ptr;
  unsigned long i, crc, c, len, x;

  ptr = (unsigned char*) data;
  crc = 0;
  len = strlen(data);

  x = (0xEDB88320 << arg) | (0xEDB88320 >> (32-arg));
  while(len != 0)
  {
    c = *ptr++;
    for(i = 0; i < 8; i++)
    {
      if ((crc ^ c) & 1)
        crc = (crc >> 1) ^ x;
      else
        crc = (crc >> 1);
      c >>= 1;
    }
    len--;
  }

  return crc;

}

unsigned char* hash_name(unsigned long arg1, unsigned long arg2)
{
  static char t[1024];
  sprintf(t, "%s_hash(%d)",
    arg1 == 0 ? "rol_add":
    arg1 == 1 ? "rol_sub":
    arg1 == 2 ? "rol_xor":
    arg1 == 3 ? "crc32" : "???",
    arg2);
  return t;
}

unsigned long hash_value(unsigned long arg1, unsigned long arg2, char* data)
{
  return arg1 == 0 ? rol_add_hash(arg2, data) :
         arg1 == 1 ? rol_sub_hash(arg2, data) :
         arg1 == 2 ? rol_xor_hash(arg2, data) :
         arg1 == 3 ? crc_hash    (arg2, data) : 0;
}

int main(int argc, char* argv[])
{
  char s[1024], **str;
  FILE *f;
  unsigned long res, i, arg1, arg2, h, count, maxcount, *tab;

  if (argc != 2)
  {
    printf("syntax:\n");
    printf("  FINDHASH api_list_file\n");
    exit(0);
  }

  tab = NULL;
  str = NULL;
  maxcount = 0;
  res = 0;

  f=fopen(argv[1],"rb");
  assert(f);

  for(arg1 = ARG1_MIN; arg1 <= ARG1_MAX; arg1 += ARG1_STEP)
  for(arg2 = ARG2_MIN; arg2 <= ARG2_MAX; arg2 += ARG2_STEP)
  {
    rewind(f);

    count = 0;
    res = 0;

    while(fgets(s, sizeof(s)-1, f))
    {
      /* remove <spaces>\r\n */
      while(s[0] && s[strlen(s)-1] <= 32)
        s[strlen(s)-1] = 0;
      /* tdump format? */

      if (!strncmp(s, "EXPORT ord:", 11))
      {
        /* <-- [EXPORT ord:0001='AddAtomA'\n] */
        /* --> [AddAtomA] */
        assert(strchr(s, 0x27));
        strcpy(s, strchr(s, 0x27) + 1);
        assert(strrchr(s, 0x27));
        *strrchr(s, 0x27) = 0;
      }

      if (s[0] && !strchr(s, 32))
      {

        h = hash_value(arg1, arg2, s);

        for(i = 0; i < count; i++)
          if (h == tab[i])
          {
            if (!strcmp(s, str[i]))
              goto skip;
            res++;
            //printf("arg = %d, collision: hash = 0x%08x, '%s' / '%s'\n", arg, h, str[i], s);
            goto skip;
          }

        if (count == maxcount)
        {
          maxcount += 65536;
          tab = (unsigned long*)realloc((void*)tab, maxcount * sizeof(unsigned long));
          str = (char**        )realloc((void*)str, maxcount * sizeof(char*        ));
          assert(tab && str);
        }

        str[count  ] = strdup(s);
        tab[count++] = h;
skip: ;

      }

    }

    printf("hash=%s, collisions=%d/%d\n", hash_name(arg1, arg2), res, count);
    fflush(stdout);

    for(i = 0; i < count; i++)
      free((void*)str[i]);

  } /* for arg1, arg2 */

  fclose(f);

  exit(0);

} /* main */

/* EOF */
