
; LDE32 -- Length-Disassembler Engine
; FREEWARE
;
; programmed by Z0MBiE, http://z0mbie.cjb.net
;
; release 1.00          8-12-99
; release 1.01          9-12-99
; release 1.02         17-03-00  0xF6/0xF7 'test' opcode bugfixed
; release 1.03         21-04-00  bugfix: some prefixes before 0F were cleared
;                                bugfix: error in MODRM analysis
;                                CD 20 now is 6 bytes length
; release 1.04          1-05-00  AAM & AAD bugfixed (was 1-byte len)
; release 1.05         xx-xx-xx  special edition, flags changed
; release 1.06          3-01-01  partially rewritten, __cdecl

                        locals  @@

C_ERROR                 equ     -1              ; never change it

C_MEM1                  equ     0001h       ; |
C_MEM2                  equ     0002h       ; |may be used simultaneously
C_MEM4                  equ     0004h       ; |
C_DATA1                 equ     0100h       ; |
C_DATA2                 equ     0200h       ; |may be used simultaneously
C_DATA4                 equ     0400h       ; |
C_67                    equ     0010h       ; used with C_PREFIX
C_MEM67                 equ     0020h       ; C_67 ? C_MEM2 : C_MEM4
C_66                    equ     1000h       ; used with C_PREFIX
C_DATA66                equ     2000h       ; C_66 ? C_DATA2 : C_DATA4
C_PREFIX                equ     0008h       ; prefix. take opcode again
C_MODRM                 equ     4000h       ; MODxxxR/M
C_DATAW0                equ     8000h       ; opc&1 ? C_DATA66 : C_DATA1

        IFDEF   TEXTID
                        db      '[disasm_init:]'
        ENDIF

; void __cdecl disasm_init(void* tableptr);

public                  disasm_main
public                  @disasm_main
public                  _disasm_main
public                  DISASM_MAIN

disasm_init:
@disasm_init:
_disasm_init:
DISASM_INIT:
                        pusha
                        mov     edi, [esp+32+4]
                        cld

                        ; Huffman-compressed 2048-byte table
                        xor     eax, eax
                        push    eax
                        push    eax
                        push    eax
                        push    002AAA800h
                        push    03FFF687Fh
                        push    0FFE6DEA0h
                        push    0DBD5FFFFh
                        push    0FFFEAAAAh
                        push    0AAAAAAAAh
                        push    0AAAA0000h
                        push    eax
                        push    eax
                        push    eax
                        push    eax
                        push    eax
                        push    eax
                        push    000000154h
                        push    041FFF555h
                        push    055DEDDAAh
                        push    019955111h
                        push    011111FFFh
                        push    0FA11FFAAh
                        push    08E60CF96h
                        push    0FC72D6AAh
                        push    0AAAAAA88h
                        push    0888888D5h
                        push    0528D559Bh
                        push    0366CD553h
                        push    0355555FFh
                        push    0FFFED6F9h
                        push    068888888h
                        push    088888888h
                        push    08D5347CAh
                        push    0DCC67BDFh
                        push    0AAAAAAAAh
                        push    0AAAAAAAAh
                        push    0ABA94FFDh
                        push    0D4A7FEEAh
                        push    053FF7529h
                        push    0FFA4A7FEh
                        push    0929FFA4Ah
                        push    07FE929FFh

                        mov     ecx, 512
                        xor     ebx, ebx
@@cycle:                xor     eax, eax
                        call    @@tree
                        stosd
                        loop    @@cycle

                        popa
                        retn

@@getbit:               or      ebx, ebx
                        jnz     @@skip
                        pop     ebp
                        pop     esi
                        pop     edx
                        push    esi
                        push    ebp
                        mov     bl, 32
@@skip:                 dec     ebx
                        shr     edx, 1
                        retn

                        ; Huffman-tree, compiled into decompressor code
@@tree:                 call    @@getbit
                        jnc     @@tree0
@@tree1:                call    @@getbit
                        jnc     @@tree10
@@tree11:               mov     ah, C_MODRM shr 8
                        retn
@@tree10:               call    @@getbit
                        jc      @@tree101
@@tree100:              call    @@getbit
                        jnc     @@tree1000
@@tree1001:             call    @@getbit
                        jnc     @@tree10010
@@tree10011:            call    @@getbit
                        jc      @@tree100111
@@tree100110:           call    @@getbit
                        jnc     @@tree1001100
@@tree1001101:          mov     al, C_MEM67
                        retn
@@tree1001100:          call    @@getbit
                        jnc     @@tree10011000
@@tree10011001:         mov     ax, C_DATA66+C_MEM2
                        retn
@@tree10011000:         call    @@getbit
                        jnc     @@tree100110000
@@tree100110001:        mov     ax, C_PREFIX+C_66
                        retn
@@tree100110000:        mov     ah, (C_DATA2+C_DATA1) shr 8
                        retn
@@tree100111:           call    @@getbit
                        jnc     @@tree1001110
@@tree1001111:          mov     ah, (C_MODRM+C_DATA66) shr 8
                        retn
@@tree1001110:          call    @@getbit
                        jnc     @@tree10011100
@@tree10011101:         mov     al, C_PREFIX+C_67
                        retn
@@tree10011100:         mov     ah, C_DATA2 shr 8
                        retn
@@tree10010:            mov     ah, C_DATAW0 shr 8
                        retn
@@tree1000:             mov     ah, C_DATA1 shr 8
                        retn
@@tree101:              call    @@getbit
                        jnc     @@tree1010
@@tree1011:             call    @@getbit
                        jnc     @@tree10110
@@tree10111:            mov     al, C_PREFIX
                        retn
@@tree10110:            mov     ah, (C_MODRM+C_DATA1) shr 8
                        retn
@@tree1010:             mov     ah, C_DATA66 shr 8
                        retn
@@tree0:                call    @@getbit
;                       jc      @@tree01
                        adc     al, 0
@@tree00:               dec     eax
@@tree01:               retn

        IFDEF   TEXTID
                        db      '[disasm_init_end:]'
                        db      '[disasm_main:]'
        ENDIF

; int __cdecl disasm_main(void* opcodeptr, void* tableptr)
; {

public                  disasm_main
public                  @disasm_main
public                  _disasm_main
public                  DISASM_MAIN

; returns opcode length in EAX or -1 if error

disasm_main:
_disasm_main:
@disasm_main:
DISASM_MAIN:            pusha

                        mov     esi, [esp+32+4]    ; tableptr
                        mov     ecx, [esp+32+8]    ; param = opcode ptr

                        xor     edx, edx        ; flags
                        xor     eax, eax

@@prefix:               and     dl, not C_PREFIX

                        mov     al, [ecx]
                        inc     ecx

                        or      edx, [esi+eax*4]

                        test    dl, C_PREFIX
                        jnz     @@prefix

                        cmp     al, 0F6h
                        je      @@test
                        cmp     al, 0F7h
                        je      @@test

                        cmp     al, 0CDh
                        je      @@int

                        cmp     al, 0Fh
                        je      @@0F
@@cont:
                        test    dh, C_DATAW0 shr 8
                        jnz     @@dataw0
@@dataw0done:
                        test    dh, C_MODRM shr 8
                        jnz     @@modrm
@@exitmodrm:
                        test    dl, C_MEM67
                        jnz     @@mem67
@@mem67done:
                        test    dh, C_DATA66 shr 8
                        jnz     @@data66
@@data66done:
                        mov     eax, ecx
                        sub     eax, [esp+32+8]

                        and     edx, C_MEM1+C_MEM2+C_MEM4 + C_DATA1+C_DATA2+C_DATA4
                        add     al, dl
                        add     al, dh

@@exit:                 mov     [esp+7*4], eax

                        popa
                        retn

@@test:                 or      dh, C_MODRM shr 8
                        test    byte ptr [ecx], 00111000b  ; F6/F7 -- test
                        jnz     @@cont
                        or      dh, C_DATAW0 shr 8
                        jmp     @@cont

@@int:                  or      dh, C_DATA1 shr 8
                        cmp     byte ptr [ecx], 20h
                        jne     @@cont
                        or      dh, C_DATA4 shr 8
                        jmp     @@cont

@@0F:                   mov     al, [ecx]
                        inc     ecx
                        or      edx, [esi+eax*4+1024]      ; 2nd half

                        cmp     edx, -1
                        jne     @@cont

@@error:                mov     eax, edx
                        jmp     @@exit

@@dataw0:               xor     dh, C_DATA66 shr 8
                        test    al, 00000001b
                        jnz     @@dataw0done
                        xor     dh, (C_DATA66+C_DATA1) shr 8
                        jmp     @@dataw0done

@@mem67:                xor     dl, C_MEM2
                        test    dl, C_67
                        jnz     @@mem67done
                        xor     dl, C_MEM4+C_MEM2
                        jmp     @@mem67done

@@data66:               xor     dh, C_DATA2 shr 8
                        test    dh, C_66 shr 8
                        jnz     @@data66done
                        xor     dh, (C_DATA4+C_DATA2) shr 8
                        jmp     @@data66done

@@modrm:                mov     al, [ecx]
                        inc     ecx

                        mov     ah, al  ; ah=mod, al=rm

                        and     ax, 0C007h
                        cmp     ah, 0C0h
                        je      @@exitmodrm

                        test    dl, C_67
                        jnz     @@modrm16

@@modrm32:              cmp     al, 04h
                        jne     @@a

                        mov     al, [ecx]       ; sib
                        inc     ecx
                        and     al, 07h

@@a:                    cmp     ah, 40h
                        je      @@mem1
                        cmp     ah, 80h
                        je      @@mem4

                        cmp     ax, 0005h
                        jne     @@exitmodrm

@@mem4:                 or      dl, C_MEM4
                        jmp     @@exitmodrm

@@mem1:                 or      dl, C_MEM1
                        jmp     @@exitmodrm

@@modrm16:              cmp     ax, 0006h
                        je      @@mem2
                        cmp     ah, 40h
                        je      @@mem1
                        cmp     ah, 80h
                        jne     @@exitmodrm

@@mem2:                 or      dl, C_MEM2
                        jmp     @@exitmodrm

                        endp

        IFDEF   TEXTID
                        db      '[disasm_main_end:]'
        ENDIF
