uses dos;

{ {{{ test stdcomment (* *) }
(* test altcomment {} *( (* *)

{$IFDEF XXXDEBUGXX}
{$I SUX1.INC}
{$ELSE
{$I SUX2.INC}
{$ENDIF}

type
  topt = array[1..2] of pchar;

const
  pas_background      =  1;
  pas_text            =  2;
  pas_link            =  3;
  pas_alink           =  4;
  pas_vlink           =  5;
  pas_basefont        =  6;
  pas_stdcmt_s        =  7;
  pas_stdcmt_e        =  8;
  pas_altcmt_s        =  9;
  pas_altcmt_e        = 10;
  pas_text_s          = 11;
  pas_text_e          = 12;
  pas_decnumber_s     = 13;
  pas_decnumber_e     = 14;
  pas_char_s          = 15;
  pas_char_e          = 16;
  pas_compdir_s       = 17;
  pas_compdir_e       = 18;
  pas_procdir_s       = 19;
  pas_procdir_e       = 20;
  pas_rw_s            = 21;
  pas_rw_e            = 22;
  pas_basm_stdcmt_s   = 23;
  pas_basm_stdcmt_e   = 24;
  pas_basm_altcmt_s   = 25;
  pas_basm_altcmt_e   = 26;
  pas_basm_text_s     = 27;
  pas_basm_text_e     = 28;
  pas_basm_decnumber_s= 29;
  pas_basm_decnumber_e= 30;
  pas_basm_char_s     = 31;
  pas_basm_char_e     = 32;
  pas_basm_compdir_s  = 33;
  pas_basm_compdir_e  = 34;
  pas_basm_rw_s       = 35;
  pas_basm_rw_e       = 36;
  pas_hexnumber_s     = 37;
  pas_hexnumber_e     = 38;
  pas_basm_hexnumber_s= 39;
  pas_basm_hexnumber_e= 40;
  pas_asm_s           = 41;
  pas_asm_e           = 42;
  pas_textchar_s      = 43;
  pas_textchar_e      = 44;

const
  pas_max = 44;
  pas_name : array[1..pas_max] of string[40] =
(
'Pascal.Background',
'Pascal.Text',
'Pascal.Link',
'Pascal.ALink',
'Pascal.VLink',
'Pascal.BaseFont',
'Pascal.StdComment.Start',
'Pascal.StdComment.End',
'Pascal.AltComment.Start',
'Pascal.AltComment.End',
'Pascal.Text.Start',
'Pascal.Text.End',
'Pascal.DecimalNumber.Start',
'Pascal.DecimalNumber.End',
'Pascal.Char.Start',
'Pascal.Char.End',
'Pascal.CompilerDirective.Start',
'Pascal.CompilerDirective.End',
'Pascal.ProcDirective.Start',
'Pascal.ProcDirective.End',
'Pascal.ReservedWord.Start',
'Pascal.ReservedWord.End',
'Pascal.BASM.StdComment.Start',
'Pascal.BASM.StdComment.End',
'Pascal.BASM.AltComment.Start',
'Pascal.BASM.AltComment.End',
'Pascal.BASM.Text.Start',
'Pascal.BASM.Text.End',
'Pascal.BASM.DecimalNumber.Start',
'Pascal.BASM.DecimalNumber.End',
'Pascal.BASM.Char.Start',
'Pascal.BASM.Char.End',
'Pascal.BASM.CompilerDirective.Start',
'Pascal.BASM.CompilerDirective.End',
'Pascal.BASM.ReservedWord.Start',
'Pascal.BASM.ReservedWord.End',
'Pascal.HexadecimalNumber.Start',
'Pascal.HexadecimalNumber.End',
'Pascal.BASM.HexadecimalNumber.Start',
'Pascal.BASM.HexadecimalNumber.End',
'Pascal.BASM.Start',
'Pascal.BASM.End',
'Pascal.TextChar.Start',
'Pascal.TextChar.End');

const
  asm_background      =  1;
  asm_text            =  2;
  asm_link            =  3;
  asm_alink           =  4;
  asm_vlink           =  5;
  asm_basefont        =  6;
  asm_cmt_s           =  7;
  asm_cmt_e           =  8;
  asm_text1_s         =  9;
  asm_text1_e         = 10;
  asm_text2_s         = 11;
  asm_text2_e         = 12;
  asm_decimal_s       = 13;
  asm_decimal_e       = 14;
  asm_hexadecimal_s   = 15;
  asm_hexadecimal_e   = 16;
  asm_octal_s         = 17;
  asm_octal_e         = 18;
  asm_binary_s        = 19;
  asm_binary_e        = 20;
  asm_res1_s          = 21;
  asm_res1_e          = 22;
  asm_res2_s          = 23;
  asm_res2_e          = 24;
  asm_char_s          = 25;
  asm_char_e          = 26;

const
  asm_max = 26;
  asm_name : array[1..asm_max] of string[40] =
(
'Asm.Background',
'Asm.Text',
'Asm.Link',
'Asm.ALink',
'Asm.VLink',
'Asm.BaseFont',
'Asm.Comment.Start',
'Asm.Comment.End',
'Asm.Text1.Start',
'Asm.Text1.End',
'Asm.Text2.Start',
'Asm.Text2.End',
'Asm.Decimal.Start',
'Asm.Decimal.End',
'Asm.Hexadecimal.Start',
'Asm.Hexadecimal.End',
'Asm.Octal.Start',
'Asm.Octal.End',
'Asm.Binary.Start',
'Asm.Binary.End',
'Asm.Register.Start',
'Asm.Register.End',
'Asm.ReservedWord.Start',
'Asm.ReservedWord.End',
'Asm.Char.Start',
'Asm.Char.End'

);

var
  cfg_name  : array[1..100]     of string[40];
  cfg_value : array[1..pas_max] of string[40];

function uc(s : string) : string; far;
  var
    i : integer;
  begin
    for i := 1 to length(s) do
      if s[i] in ['a'..'z'] then dec(s[i], 32);
    uc := s;
  end;

function lc(s : string) : string; near;
  var
    i : integer;
  begin
    for i := 1 to length(s) do
      if s[i] in ['A'..'Z'] then inc(s[i], 32);
    lc := s;
  end;

procedure help;
  begin
    writeln('Syntax:');
    writeln('  SRC2HTM [[-|/]option(s)] infile [outfile[.HTM]] [[#|@]cfgfile[.CFG]]');
    writeln('Options:');
    writeln('  /ASM    language=Assembler');
    writeln('  /C      language=C               [NOT IMPLEMENTED IN 1.01]');
    writeln('  /PAS    language=Pascal');
    halt;
  end;

const
  was_warn : boolean = false;

procedure warning(warn : string);
  begin
    was_warn := true;
    writeln('*** Warning ***: ',warn);
  end;

procedure error(msg : string);
  begin
    if was_warn then writeln;
    writeln('*** Error ***: ',msg);
    halt(1);
  end;

type
  tlng = (lng_no,
          lng_asm,
          lng_c,
          lng_pas);

const
  lng : tlng = lng_no;

const
  max : array[tlng] of word = ($FFFF, asm_max,0,pas_max);

procedure set_lng(__lng : tlng);
  begin
    if lng <> lng_no then
      error('Language alredy specified')
    else
      lng := __lng;
  end;

const
  ibufsize = 8192;
  obufsize = 8192;

var
  infile, outfile, cfgfile : string;
  i, j : integer;
  origname, s : string;
  _d : dirstr;
  _n : namestr;
  _e : extstr;
  ir : searchrec;
  f1, f2 : file;
  lngE : tlng;
  b : boolean;
  t : text;
  attr : word;

  ibuf : array[1..ibufsize] of char;
  imax, imax2 : word;
  iptr : word;
  obuf : array[1..obufsize] of char;
  omax : word;

  c,d,e : char;

procedure getbuf;
  begin
    blockread(f1, ibuf, ibufsize, imax);
    iptr := 0;
  end;

procedure getchar;
  begin
    if (imax = 0) or (iptr >= imax) then getbuf;

    inc(iptr);
    c := ibuf[iptr];

    if iptr >= imax then getbuf;

    d := ibuf[iptr+1];

  end;

function EOI : boolean;
  begin
    EOI := eof(f1) and (iptr >= imax);
  end;

procedure put(s : string);
  var
    i : integer;
  begin
    for i := 1 to length(s) do
    begin
      inc(omax);
      obuf[omax] := s[i];
      if omax >= obufsize then
      begin
       blockwrite(f2, obuf, omax);
       omax := 0;
      end;
    end;
  end;

procedure init_all(s1:string;n1,n2,n3,n4,n5,n6:word);
  begin
    put('<HTML>'#13#10);
    put('<HEAD>'#13#10);
    put('<TITLE>'+origname+'</TITLE>'#13#10);
    put('<!-- File created by SRC2HTM - Source To .HTM Convertor, (c) 1998 Z0MBiE -->'#13#10);
    put('</HEAD>'#13#10);
    put('<BODY'+
        +' BGCOLOR='+cfg_value[n1]
        +' TEXT='+cfg_value[n2]
        +' LINK='+cfg_value[n3]
        +' ALINK='+cfg_value[n4]
        +' VLINK='+cfg_value[n5]+'>'#13#10);
    put(cfg_value[n6]+#13#10);
    put('<!-- Target Language: '+s1+' -->'#13#10);
  end;

procedure init_pas;
  begin
    init_all('Pascal',pas_background,pas_text,pas_link,pas_alink,pas_vlink,pas_basefont);
  end;

procedure init_asm;
  begin
    init_all('Assembler',asm_background,asm_text,asm_link,asm_alink,asm_vlink,asm_basefont);
  end;

procedure convertor_asm;

  const
    mode_cmt   : boolean = false;
    mode_text1 : boolean = false;
    mode_text2 : boolean = false;

  function res_1(s : string) : boolean;
    const
      m1 = 48;
      s1 : array[1..m1] of string[10] =
        ('AL','AH','BL','BH','CL','CH','DL','DH','AX','BX','CX','DX','SI','DI',
         'SP','BP','FLAGS','EFLAGS','EAX','EBX','ECX','EDX','ESI','EDI','ESP',
         'EBP','CS','DS','SS','ES','FS','GS','CR0','CR1','CR2','CR3','CR4','CR5',
         'CR6','CR7','DR0','DR1','DR2','DR3','DR4','DR5','DR6','DR7');
    var
      i : integer;
    begin
      res_1 := true;
      s := uc(s);
      for i := 1 to m1 do
        if s1[i] = s then exit;
      res_1 := false;
    end;

  function res_2(s : string) : boolean;
    const
      m2 = 22;
      s2 : array[1..m2] of string[10] =
        ('CODE','DATA','STACK','SEGMENT','SEG','ASSUME','ORG','EVEN','ODD',
         'PROC','MACRO','STRUC','ENDM','ENDP','ENDS','EQU',
         'EXTRN','PUBLIC','EMDP','ENDS','ENDM','END');

    var
      i : integer;
    begin
      res_2 := true;
      s := uc(s);
      for i := 1 to m2 do
        if s2[i] = s then exit;
      res_2 := false;
    end;

  begin

    getchar;

    if (c = ';') and (not mode_text1) and (not mode_text2) and (not mode_cmt) then
    begin
      mode_cmt := true;
      put(cfg_value[asm_cmt_s]);
      put(c);
    end else

    if (c = '''') and (not mode_text2) and (not mode_cmt) then
    begin
      if not mode_text1 then begin
        mode_text1 := true;
        put(cfg_value[asm_text1_s]);
        put(c);
      end else begin
        put(c);
        put(cfg_value[asm_text1_e]);
        mode_text1 := false;
      end;
    end else

    if (c = '"') and (not mode_text1) and (not mode_cmt) then
    begin
      if not mode_text2 then begin
        mode_text2 := true;
        put(cfg_value[asm_text2_s]);
        put(c);
      end else begin
        put(c);
        put(cfg_value[asm_text2_e]);
        mode_text2 := false;
      end;
    end else

    if (c in ['0'..'9']) and (not mode_text1) and (not mode_text2) and (not mode_cmt) then
    begin
      s := c;
      if d in ['0'..'9','a'..'z','A'..'Z','_','@','?'] then
      repeat
        getchar;
        s := s + c;
        if d in ['0'..'9','a'..'z','A'..'Z','_','@','?'] then else break;
      until EOI;

      if (s[2] in ['x','X']) or (s[length(s)] in ['h','H']) then
      begin
        put(cfg_value[asm_hexadecimal_s]);
        put(s);
        put(cfg_value[asm_hexadecimal_e]);
      end else

      if s[length(s)] in ['b','B'] then
      begin
        put(cfg_value[asm_binary_s]);
        put(s);
        put(cfg_value[asm_binary_e]);
      end else

      if s[length(s)] in ['o','O'] then
      begin
        put(cfg_value[asm_octal_s]);
        put(s);
        put(cfg_value[asm_octal_e]);
      end else

      begin
        put(cfg_value[asm_decimal_s]);
        put(s);
        put(cfg_value[asm_decimal_e]);
      end;

    end else

    if (c in ['_','a'..'z','A'..'Z','@','?']) and
      (not mode_text1) and (not mode_text2) and (not mode_cmt) then
    begin
      s := c;

      if d in ['a'..'z','A'..'Z','0'..'9','_','@','?'] then
      repeat
        getchar;
        s := s + c;
        if d in ['a'..'z','A'..'Z','0'..'9','_','@','?'] then else break;
      until EOI;

      if res_1(s) then
      begin
        put(cfg_value[asm_res1_s]);
        put(s);
        put(cfg_value[asm_res1_e]);
      end else

      if res_2(s) then
      begin
        put(cfg_value[asm_res2_s]);
        put(s);
        put(cfg_value[asm_res2_e]);
      end else

      put(s);

    end else

    if c = #13 then
    begin

      if mode_cmt then
      begin
        put(cfg_value[asm_cmt_e]);
        mode_cmt := false;
      end;

      put(c);
    end else

    if (c in ['[',']','+','-','*','/','\','(',')','<','>','=',',','.','?']) and
      (not mode_text1) and (not mode_text2) and (not mode_cmt) then
    begin

      put(cfg_value[asm_char_s]);
      case c of
        '<': put('&lt;');
        '>': put('&gt;');
        '&': put('&amp;');
        '"': put('&quot;');
        else put(c);
      end;
      put(cfg_value[asm_char_e]);

    end else

      put(c);

  end;

procedure convertor_c;
  begin
  end;

procedure convertor_pas;

  function res_1(s : string) : boolean;
    const
      m1 = 41;
      s1 : array[1..m1] of string[10] =
       ('AH','AL','AND','AX','BH','BL','BP','BX','BYTE','CH','CL','CS','CX',
        'DH','DI','DL','DS','DWORD','DX','ES','FAR','HIGH','LOW','MOD','NEAR',
        'NOT','OFFSET','OR','PTR','QWORD','SEG','SHL','SHR','SI','SP','SS'
        ,'ST','TBYTE','TYPE','WORD','XOR');
    var
      i : integer;
    begin
      res_1 := true;
      s := uc(s);
      for i := 1 to m1 do
        if s1[i] = s then exit;
      res_1 := false;
    end;

  function res_2(s : string) : boolean;
    const
      m2 = 51;
      s2 : array[1..m2] of string[10] =
       ('and','asm','array','begin','case','const','constructor','destructor',
       'div','do ','downto','else','end','exports','file','for','function',
       'goto','if','implementation','in','inherited','inline','interface','label',
       'library','mod','nil','not','object','of','or','packed','procedure','program',
       'record','repeat','set','shl','shr','string','then','to','type','unit',
       'until','uses','var','while','with','xor');
    var
      i : integer;
    begin
      res_2 := true;
      s := lc(s);
      for i := 1 to m2 do
        if s2[i] = s then exit;
      res_2 := false;
    end;

  function res_3(s : string) : boolean;
    const
      m3 = 13;
      s3 : array[1..m3] of string[10] =
        ('absolute','assembler','export','external','far',
        'forward','index','interrupt','near','private','public',
        'resident','virtual');
    var
      i : integer;
    begin
      res_3 := true;
      s := lc(s);
      for i := 1 to m3 do
        if s3[i] = s then exit;
      res_3 := false;
    end;

  const
    mode_stdcmt : boolean = false;
    mode_altcmt : boolean = false;
    mode_text   : boolean = false;
    mode_asm    : boolean = false;
    pas_compdir1: boolean = false;
    pas_compdir2: boolean = false;

  begin

    getchar;

    if (c = '{') and (not mode_stdcmt) and (not mode_altcmt) and (not mode_text) then
    begin
      mode_stdcmt := true;
      if mode_asm then
        put(cfg_value[pas_basm_stdcmt_s])
      else
        put(cfg_value[pas_stdcmt_s]);

      if (d = '$') and (not pas_compdir1) then
      begin
        pas_compdir1 := true;
        if mode_asm then
          put(cfg_value[pas_basm_compdir_s])
        else
          put(cfg_value[pas_compdir_s]);
      end;

      put(c);


    end else

    if (c = '}') and mode_stdcmt and (not mode_altcmt) and (not mode_text) then
    begin
      put(c);

      if pas_compdir1 then
      begin
        pas_compdir1 := false;
        if mode_asm then
          put(cfg_value[pas_basm_compdir_e])
        else
          put(cfg_value[pas_compdir_e]);
      end;

      if mode_asm then
        put(cfg_value[pas_basm_stdcmt_e])
      else
        put(cfg_value[pas_stdcmt_e]);
      mode_stdcmt := false;

    end else

    if (c = '(') and (d = '*') and (not mode_stdcmt) and (not mode_altcmt) and (not mode_text) then
    begin
      mode_altcmt := true;
      if mode_asm then
        put(cfg_value[pas_basm_altcmt_s])
      else
        put(cfg_value[pas_altcmt_s]);
      put(c);
    end else

    if (c = '*') and (d = ')') and (not mode_stdcmt) and mode_altcmt and (not mode_text) then
    begin
      put(c);
      getchar;
      put(c);
      if mode_asm then
        put(cfg_value[pas_basm_altcmt_e])
      else
        put(cfg_value[pas_altcmt_e]);
      mode_altcmt := false;
    end else

    if (c = '''') and (not mode_stdcmt) and (not mode_altcmt) then
    begin
      if not mode_text then begin
        mode_text := true;
        if mode_asm then
          put(cfg_value[pas_basm_text_s])
        else
          put(cfg_value[pas_text_s]);
        put(c);
      end else begin
        put(c);
        if mode_asm then
          put(cfg_value[pas_basm_text_e])
        else
          put(cfg_value[pas_text_e]);
        mode_text := false;
      end;
    end else

    if (c in ['$','0'..'9']) and (not mode_stdcmt) and (not mode_altcmt) and (not mode_text) then
    begin
      s := c;
      if (d in ['0'..'9','a'..'z','A'..'Z','_']) or (mode_asm and (d = '@')) then
      repeat
        getchar;
        s := s + c;
        if d in ['0'..'9','a'..'z','A'..'Z','_','@'] then else break;
      until EOI;
      if s[1] = '$' then begin
        if mode_asm then
          put(cfg_value[pas_basm_hexnumber_s])
        else
          put(cfg_value[pas_hexnumber_s]);
        put(s);
        if mode_asm then
          put(cfg_value[pas_basm_hexnumber_e])
        else
          put(cfg_value[pas_hexnumber_e]);
      end else begin
        if mode_asm then
          put(cfg_value[pas_basm_decnumber_s])
        else
          put(cfg_value[pas_decnumber_s]);
        put(s);
        if mode_asm then
          put(cfg_value[pas_basm_decnumber_e])
        else
          put(cfg_value[pas_decnumber_e]);
      end;
    end else

    if (c = '#') and (not mode_altcmt) and (not mode_stdcmt) and (not mode_text) then
    begin
      s := c;
      if (d in ['0'..'9','$','#']) then
      repeat
        getchar;
        s := s + c;
        if d in ['0'..'9','$','#'] then else break;
      until EOI;
      put(cfg_value[pas_textchar_s]);
      put(s);
      put(cfg_value[pas_textchar_e]);
    end else

    if ((c in ['a'..'z','A'..'Z','_']) or (mode_asm and (c = '@')) ) and (not mode_stdcmt)
           and (not mode_altcmt) and (not mode_text) then
    begin
      s := c;
      if (d in ['0'..'9','a'..'z','A'..'Z','_','@']) or (mode_asm and (d = '@')) then
      repeat
        getchar;
        s := s + c;
        if d in ['0'..'9','a'..'z','A'..'Z','_','@'] then else break;
      until EOI;

      if (uc(s) = 'ASM') and (not mode_asm) then
      begin
        put(s);
        put(cfg_value[pas_asm_s]);
        mode_asm := true;
      end else

      if (uc(s) = 'END') and mode_asm then
      begin
        mode_asm := false;
        put(cfg_value[pas_asm_e]);
        put(s);
      end else

      if res_1(s) and mode_asm then
      begin
        put(cfg_value[pas_basm_rw_s]);
        put(s);
        put(cfg_value[pas_basm_rw_e]);
      end else

      if res_2(s) and (not mode_asm) then
      begin
        put(cfg_value[pas_rw_s]);
        put(s);
        put(cfg_value[pas_rw_e]);
      end else

      if res_3(s) and (not mode_asm) then
      begin
        put(cfg_value[pas_procdir_s]);
        put(s);
        put(cfg_value[pas_procdir_e]);
      end else

        put(s);

    end else

    if c in ['<','>','&','"','=','(',')','[',']',':',';','.','^',',','+','-','*','/','\'] then
    begin
      if (not mode_stdcmt) and (not mode_altcmt) and (not mode_text) then
      begin
        if mode_asm then
          put(cfg_value[pas_basm_char_s])
        else
          put(cfg_value[pas_char_s]);
      end;
      case c of
        '<': put('&lt;');
        '>': put('&gt;');
        '&': put('&amp;');
        '"': put('&quot;');
        else put(c);
      end;
      if (not mode_stdcmt) and (not mode_altcmt) and (not mode_text) then
      begin
        if mode_asm then
          put(cfg_value[pas_basm_char_e])
        else
          put(cfg_value[pas_char_e]);
      end;
    end else

      {if c = #32 then
        put('&nbsp;')
      else}
        put(c);

  end;

begin

  writeln('SRC2HTM  Source To .HTM Convertor  Version 1.01  Copyright (c) 1998 Z0MBiE');
  writeln;

  if paramcount = 0 then help;

  infile  := '';
  outfile := '';
  cfgfile := '';
  j := 0;
  for i := 1 to paramcount do
  begin
    s := uc(paramstr(i));

    if s[1] in ['-','/'] then begin

      delete(s,1,1);

      if (s = '?') or (s = 'H') or (s = 'HELP') then help;

      if s = 'ASM' then set_lng(lng_asm) else
      if s = 'C'   then set_lng(lng_c  ) else
      if s = 'PAS' then set_lng(lng_pas) else
        error('Unknown option: "'+s+'"');

    end else

    if s[1] in ['#','@'] then
    begin

      if cfgfile <> '' then error('Configuration file alredy specified');

      delete(s,1,1);
      fsplit(fexpand(s), _d,_n,_e);
      if _e = '' then _e := '.CFG';

      cfgfile := _d+_n+_e;

    end else

    begin

      inc(j);
      case j of
        1: infile  := fexpand(s);
        2: outfile := fexpand(s);
        3: error('Too many parameters: "'+s+'"');
      end;

    end;

  end;

  if infile = '' then error('Input file not specified');

  fsplit(infile, _d,_n,_e);

  origname := _n+_e;

  if _e = '.ASM' then
  begin
    if lng = lng_no then
      warning('Language not specified, using Assembler');
    lngE := lng_asm;
    _e := '';
  end else

  if _e = '.C' then
  begin
    if lng = lng_no then
      warning('Language not specified, using C');
    lngE := lng_c;
    _e := '';
  end else

  if _e = '.PAS' then
  begin
    if lng = lng_no then
      warning('Language not specified, using Pascal');
    lngE := lng_pas;
    _e := '';
  end else

    if lng = lng_no then
      error('Language not specified');

  if lng = lng_no then
    lng := lngE
  else
    if lng <> lngE then
      warning('Language and file extension are not the same');

  _e := '.HTM';

  b := outfile = '';
  if not b then
  begin
    fsplit(outfile, _d,_n,_e);
    if _e = '' then _e := '.HTM';
  end;

  case lng of
    lng_asm: move(asm_name, cfg_name, sizeof(asm_name));
    lng_c:   ;
    lng_pas: move(pas_name, cfg_name, sizeof(pas_name));
  end;

  for i := 1 to max[lng] do
    cfg_value[i] := '';

  outfile := _d+_n+_e;
  if b then
  warning('Output file not specified, using '+outfile);

  findfirst(infile, anyfile, ir);
  if doserror <> 0 then
    error('Input file not found: "'+infile+'"');

  if cfgfile = '' then
    warning('Configuration file not specified')
  else begin

    assign(t, cfgfile);
    getfattr(t, attr);
    if doserror <> 0 then
      error('Error opening configuration file: "'+cfgfile+'"');
    reset(t);
    while not eof(t) do
    begin
      readln(t, s);
      if s <> '' then
      if s[1] <> ';' then
      begin
        for i := 1 to max[lng] do
          if copy(uc(s),1,length(cfg_name[i])+1) = uc(cfg_name[i])+' ' then
          begin
            delete(s,1,length(cfg_name[i])+1);

            while s[1] in [#32,#9] do delete(s,1,1);

            if cfg_value[i] <> '' then
              error('Duplicated parameter: "'+cfg_name[i]+'"');

            if length(s) > sizeof(cfg_value)-1 then
              error('Too big parameter: name="'+cfg_name[i]+'" value="'+s+'"');

            cfg_value[i] := s;

            break;
          end;
      end;
    end;
    close(t);

  end;

  for i := 1 to max[lng] do
    if cfg_value[i] = '' then error('OPTION NOT SPECIFIED: "'+cfg_name[i]+'"');

  assign(f1, infile);
  filemode := 0;
  reset(f1,1);
  if ioresult <> 0 then error('Error opening input file: "'+infile+'"');

  assign(f2, outfile);
  setfattr(f2, archive);
  rewrite(f2,1);
  if ioresult <> 0 then error('Error opening output file: "'+outfile+'"');

  if was_warn then writeln;

  if (lng = lng_c) then
  begin
    writeln('Sorry, but C-language convertor not programmed yet.');
    close(f1);
    close(f2);
    halt;
  end;

  imax := 0;
  iptr := 0;
  omax := 0;

  write('Converting...');

  case lng of
    lng_asm: init_asm;
    lng_c:   ;
    lng_pas: init_pas;
  end;

  while not EOI do
  begin

    case lng of
      lng_asm: convertor_asm;
      lng_c  : convertor_c;
      lng_pas: convertor_pas;
    end;

  end;

  put('</BODY>'#13#10);
  put('</HTML>'#13#10);

  if omax <> 0 then
    blockwrite(f2, obuf, omax);

  writeln(#13'Converted, ',filesize(f1),' to ',filesize(f2),' byte(s)');

  close(f1);
  close(f2);

  i := $1234;
  asm
    jmp     @@1
    nop
    xor     ax, ax
{$IFDEF DPMI}
    mov     cx, 1
{$ENDIF}
    mov     cx, $1234
@@data:
    db      1,2,$3,'abcd'
    xor     bx, bx
    mov     cx, word ptr [bx]
@@1:
  end;
end.
