
// permutating engine. unfinished & not tested enough

#define DUMP_STAT
#define DUMP_HEX
#define DUMP_MSG
#define DUMP_MSG_LINK
#define DUMP_ERROR
#define DUMP_FILES

#define MAXSIZE 65536
#define MAXCMD  16384

#define MAX_SEARCH_ITER 1000

#define M_NONE  '-'
#define M_CODE  'c'
#define M_NEXT  'N'

#define FILLER          0xCC

#define J_TOP           32
#define J_BOTTOM        32
#define J_LEFT          32
#define J_RIGHT         32

int engine(BYTE  ibuf[],                // input buffer
           DWORD isize,                 // input buffer size
           DWORD ientry,                // input buffer entry point (relative)
           BYTE  obuf[],                // output buffer
           DWORD osize,                 // output buffer size
           DWORD *oentry,               // pointer to outbuffer entry point
           int   cdecl disasm(void* x)  // external disassembling subroutine
           )
{

#ifdef DUMP_STAT
  printf("ibuf ......... %08X\n",ibuf);
  printf("isize ........ %08X\n",isize);
  printf("ientry ....... %08X\n",ientry);
  printf("obuf ......... %08X\n",obuf);
  printf("osize ........ %08X\n",osize);
#endif

// info for each byte in the input buffer
  BYTE map[MAXSIZE];

// link information
  DWORD ilink[MAXCMD];
  DWORD olink[MAXCMD];
  DWORD ncmd=0;

#ifdef DUMP_MSG
  printf("initializing\n");
#endif

  for (DWORD i=0; i<isize; i++) map[i]=M_NONE;
  for (DWORD i=0; i<osize; i++) obuf[i]=FILLER;

// select random outbuf entrypoint
  DWORD outip = random(osize-J_BOTTOM);
  *oentry = outip;
#ifdef DUMP_STAT
  printf("outbuf entry at %08X\n", *oentry);
#endif

#ifdef DUMP_MSG
  printf("marking entrypoint at %08X\n", ientry);
#endif
  map[ientry]=M_NEXT;

  for (;;) // cycle -- search for M_NEXT marks
  {

#ifdef DUMP_MSG
    printf("searching for NEXT marks\n");
#endif

    DWORD i=0xFFFFFFFF;
    for (DWORD j=0; j<isize; j++)
      if (map[j]==M_NEXT)
      {
        i=j;
        break;
      }

    if (i==0xFFFFFFFF)
    {
#ifdef DUMP_MSG
      printf("NEXT mark not found\n");
#endif

// link
#ifdef DUMP_MSG_LINK
      printf("linking\n");
#endif
      for (DWORD j=0; j<ncmd; j++)
      {
        BYTE b = obuf[olink[j]];
        BYTE b1 = obuf[olink[j]+1];
        if ( (b==0xEB) || ((b&0xFC)==0xE0) || ((b&0xF0)==0x70) )
        {
#ifdef DUMP_ERROR
          printf("***ERROR***: short-jxx-alike command (0x%02X) found"\
                 "in outbuf, can not link\n", b);
#endif
          return 0;
        }
        long o=0;
        if ((b==0xE9)||(b==0xE8)) o = 1;
        if ((b==0x0F)&&((b1&0xF0)==0x80)) o = 2;
        if (o!=0)
        {
          DWORD lt = ilink[j]+o+4+ *(long*)&obuf[olink[j]+o];
#ifdef DUMP_MSG_LINK
          printf("link at %08X(%08X) to %08X(",ilink[j],olink[j],lt);
#endif
          if ((lt<0)||(lt>=osize))
          {
#ifdef DUMP_MSG_LINK
            printf("out of range)\n");
#endif
// link it anyway !
            *(long*)&obuf[olink[j]+o] = lt-(olink[j]+o+4)
              +(DWORD)ibuf-(DWORD)obuf;

          }
          else
          {
            DWORD ii=0xFFFFFFFF;
            for (DWORD k=0; k<ncmd; k++)
              if (ilink[k]==lt)
              {
                ii=k;
                break;
              }
            if (ii==0xFFFFFFFF)
            {
#ifdef DUMP_MSG_LINK
              printf("...)\n");
#endif
#ifdef DUMP_ERROR
              printf("***ERROR***: link not found at %08X\n",lt);
#endif
              return 0;
            }
#ifdef DUMP_MSG_LINK
            printf("%08X)\n",olink[ii]);
#endif
            // update link
            *(long*)&obuf[olink[j]+o] = olink[ii]-(olink[j]+o+4);
          }
        }
      }

// dump files
#ifdef DUMP_FILES

#ifdef DUMP_MSG
      printf("writing files\n");
#endif

      FILE *f = fopen("_imap","wb");
      fwrite(&map, 1,isize, f);
      fclose(f);

      for (DWORD i=0; i<isize; i++)
        if (map[i]!=M_NONE)
          map[i]=ibuf[i];
        else
          map[i]=0xCC;

      f = fopen("_icode","wb");
      fwrite(&map, 1,isize, f);
      fclose(f);

      f = fopen("_ocode","wb");
      fwrite(obuf, 1,osize, f);
      fclose(f);

#endif

#ifdef DUMP_MSG
      printf("exiting engine\n");
#endif

      return 1;
    }

#ifdef DUMP_MSG
    printf("NEXT mark found at %08X\n", i);
#endif

    for (;;) // cycle -- process code
    {

      int l=disasm(&ibuf[i]);
      if (l==-1)
      {
#ifdef DUMP_ERROR
        printf("***ERROR***: cant disassemble.\n");
#endif
        return 0;
      }

#ifdef DUMP_HEX
      printf("%08X ",i);
      for (int j=0; j<l; j++)
        printf(" %02X",ibuf[i+j]);
      printf("\n");
#endif

// mark instruction as CODE
      for (int j=0; j<l; j++) map[i+j]=M_CODE;

// find new eip
      DWORD newip = outip;
      int c;
      for (c=0; newip+c<osize, c<J_RIGHT; c++)
        if (obuf[newip+c]!=FILLER)
          break;
      if ((c<J_RIGHT)||(rndW(2)==0))
        for (int ntry=0; ; ntry++)
        {
          newip=J_TOP+random(osize-J_TOP-J_BOTTOM);
          for (c=-J_LEFT; newip+c<osize, c<J_RIGHT; c++)
            if (obuf[newip+c]!=FILLER)
              break;
          if (c>=J_RIGHT-1) break;
          if (ntry>=MAX_SEARCH_ITER)
          {
#ifdef DUMP_ERROR
            printf("***ERROR***: too small output buffer\n");
#endif
            return 0;
          }
        }

// go to new eip
      if (newip!=outip)
      {
        obuf[outip++]=0xE9;
        outip+=4;
        *(long*)&obuf[outip-4] = newip-outip;
        outip = newip;
      }

// update link information
      olink[ncmd] = outip;
      ilink[ncmd] = i;
      ncmd++;

// analyze instruction
      DWORD nxt=0;
      DWORD jto=0;
      int   end=0;
      if (ibuf[i]==0xE8)                        // call near
        nxt=i+5+(*(long*)&ibuf[i+1]);
      if (((ibuf[i]&0xF0)==0x70)||((ibuf[i]&0xFC)==0xE0))//jx/loopx/jcxz short
        nxt=i+2+(*(char*)&ibuf[i+1]);
      if ((ibuf[i]==0x0F)&&((ibuf[i+1]&0xF0)==0x80))    // jcc near
        nxt=i+6+(*(long*)&ibuf[i+2]);

      if (ibuf[i]==0xE9) jto=i+5+(*(long*)&ibuf[i+1]);  // jmp near
      if (ibuf[i]==0xEB) jto=i+2+(*(char*)&ibuf[i+1]);  // jmp short

      if (ibuf[i]==0xC2) end=1; // retn xxxx
      if (ibuf[i]==0xC3) end=1; // retn
      if (ibuf[i]==0xCA) end=1; // retf xxxx
      if (ibuf[i]==0xCB) end=1; // retf
      if (ibuf[i]==0xCF) end=1; // iret
      if ((ibuf[i]==0xFF)&&((ibuf[i+1]&0x38)==0x20)) end=1; // JMP modrm

// copy instruction to output buffer

      if (ibuf[i]==0xEB)                // replace short with near
      {
        obuf[outip++]=0xE9;
        long l = *(char*)&ibuf[i+1];
        *(long*)&obuf[outip]=l-4;
        outip+=4;
      }
      else
      if ((ibuf[i]&0xF0)==0x70)         // --//--
      {
        obuf[outip++]=0x0F;
        obuf[outip++]=ibuf[i]^(0x70^0x80);
        long l = *(char*)&ibuf[i+1];
        *(long*)&obuf[outip]=l-4;
        outip+=4;
      }
      else
      for (int j=0; j<l; j++) obuf[outip++] = ibuf[i+j];

// mark code for next pass if needed
      if (nxt!=0)
      {
#ifdef DUMP_MSG
        printf("marking next at %08X\n", nxt);
#endif
        if ((nxt>=0)&&(nxt<isize))
          if (map[nxt]==M_NONE)
            map[nxt]=M_NEXT;
#ifdef DUMP_MSG
          else
            printf("alredy marked\n");
        else
          printf("out of range\n");
#endif
      }

// terminate disasm if needed (RETs)
      if (end)
      {
#ifdef DUMP_MSG
        printf("ret-alike command -- exiting disasm\n");
#endif
        break;
      }

// change eip if needed (JMPs)
      if (jto==0)
        i+=l;
      else
      {
#ifdef DUMP_MSG
        printf("jmp to %08X\n",jto);
#endif
        i=jto;
      }

// terminate disasm if found alredy processed code
      if (map[i]==M_CODE)
      {
#ifdef DUMP_MSG
        printf("alredy code at %08X, exiting disasm\n", i);
#endif
        break;
      }

    }
  }
} //engine
