
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <io.h>

#pragma hdrstop

#include "mz.h"
#include "pe.h"

#define aligned(a,b)    ( ( (a) + (b) - 1 ) & ( ~( (b) - 1) ) )

#define hmsg "            file lastsec   phys   phys   virt   virt   file  image   ovrl\n"\
             "           align name      offs   size   .rva   size   size   size       \n"

void dump_file(char* fname)
{
  MZ_HEADER mz;
  PE_HEADER pe;
  PE_OBJENTRY oe;

  FILE*f=fopen(fname,"rb");
  assert(f);
  fread(&mz,1,sizeof(mz),f);
  fseek(f,mz.mz_neptr,SEEK_SET);
  fread(&pe,1,sizeof(pe),f);
  fseek(f,mz.mz_neptr+0x18+pe.pe_ntheadersize + (pe.pe_numofobjects-1)*sizeof(oe), SEEK_SET);
  fread(&oe,1,sizeof(oe),f);
  int fsize = filelength(fileno(f));
  fclose(f);
  printf("%-12s%4X %-8s%6X %6X %6X %6X %6X %6X %6X %c\n",
        strrchr(fname,'\\') ? strrchr(fname,'\\')+1 : fname,
        pe.pe_filealign,
        oe.oe_name,
        oe.oe_physoffs,
        oe.oe_physsize,
        oe.oe_virtrva,
        oe.oe_virtsize,
        fsize,
        pe.pe_imagesize,
        fsize - (oe.oe_physoffs + aligned(oe.oe_physsize, pe.pe_filealign)),
        pe.pe_checksum == 0 ? '0':'c',
        0
     );
}

void main(int argc, char* argv[])
{
  if (argc!=2) return;
  printf(hmsg);
  dump_file(argv[1]);
}
