
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define MIN(a,b)        ((a)<(b)?(a):(b))
#define MAX(a,b)        ((a)<(b)?(a):(b))

int main(int argc, char* argv[])
{
//printf("BRAINFUCK emulator\n");

  if (argc != 2)
  {
    printf("syntax: BRAINFUCK filename.bf\n");
    exit(0);
  }

  FILE*f=fopen(argv[1], "rb");
  if (f==NULL)
  {
    printf("ERROR: cant open file: '%s'\n", argv[1]);
    exit(0);
  }
  fseek(f, 0, SEEK_END);
  int code_len = ftell(f);
  rewind(f);
  char* code = new char[code_len];
  fread(code, 1,code_len, f);
  fclose(f);

  int data_len = 30000;
  char* data = new char[data_len];

  for(int t=0; t<data_len; t++)
    data[t] = 0;

  int code_ptr = 0;
  int data_ptr = 0;

  for(;;)
  {
    if (code_ptr >= code_len)
    {
//    printf("<break due to eof>\n");
      break;
    }

    char c = code[code_ptr++];

    switch(c)
    {
      case '@':
                {
//                printf("<break due to '@'>\n");
                  exit(0);
                }
      case '#':
                {
                  printf("p=%d,a=[");
                  for(int i=0; i<10; i++)
                    printf("%d%s", data[i], i<10-1?",":"]\n");
                }
                break;
      case '%':
                {
                  while((code[code_ptr]!='\n')&&(code_ptr<code_len))
                    code_ptr++;
                }
                break;
      case '>': data_ptr++; assert(data_ptr < data_len); break;
      case '<': data_ptr--; assert(data_ptr >= 0); break;
      case '+': data[data_ptr]++; break;
      case '-': data[data_ptr]--; break;
      case '.': putchar(data[data_ptr]); break;
      case ',': data[data_ptr] = getchar(); break;
      case '[':
           {
             if (data[data_ptr] == 0)
             {
               code_ptr--;
               int z = 0;
               do
               {
                 assert(code_ptr < code_len);
                 if (code[code_ptr]=='[') z++;
                 if (code[code_ptr]==']') z--;
                 code_ptr++;
               }
               while(z);
               assert(code[code_ptr-1]==']');
             }
           }
           break;
      case ']':
           {
             int z = 0;
             do
             {
               code_ptr--;
               assert(code_ptr >= 0);
               if (code[code_ptr]==']') z--;
               if (code[code_ptr]=='[') z++;
             }
             while(z);
             assert(code[code_ptr]=='[');
           }
           break;
      default:
           // ignore
           break;
    }

  }

  fclose(f);

} // main
