
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

int def_var();                                  // +
void to(int s);                                 // +
void add_z(int d, int s);                       // d += s, s = 0
void copy_z(int d, int s);                      // d = s, s = 0
void copy2_z(int d1,int d2, int s);             // d1 = d2 = s, s = 0
void copy(int d,int s);                         // d = s
void clear(int d);                              // d = 0
void addconst(int d,int c);                     // d += c
void subconst(int d,int c);                     // d -= c
void inc(int d);                                // ++d
void dec(int d);                                // --d
void settoconst(int d,int c);                   // d = c
void multiplybyconst_z(int d,int s,int c);      // d = s * c, s = 0
void multiplybyconst(int d,int s,int c);        // d = s * c
void _if_z(int a);                              // if (a) { ...
void _endif_z(int a);                           // ... }, a = 0

// system vars
int var_t1;
int var_t2;

int def_var()
{
  static int __def_var_ptr = 0;
  return __def_var_ptr++;
}

void to(int s)
{
  static int __ptr = 0;
  while(__ptr != s)
    if (__ptr < s)
    {
      printf(">");
      __ptr++;
    }
    else
    {
      printf("<");
      __ptr--;
    }
}

void clear(int d)
{
  to(d);
  printf("[-]");
}

void add_z(int d, int s)
{
  to(s);
  printf("[");
  to(d);
  printf("+");
  to(s);
  printf("-");
  printf("]");
}

void copy_z(int d, int s)
{
  clear(d);
  add_z(d, s);
}

void copy2_z(int d1,int d2, int s)
{
  clear(d1);
  clear(d2);
  to(s);
  printf("[");
  to(d1);
  printf("+");
  to(d2);
  printf("+");
  to(s);
  printf("-");
  printf("]");
}

void copy(int d,int s)
{
  copy2_z(d,var_t1,s);
  copy_z(s,var_t1);
}

void addconst(int d,int c)
{
  to(d);
  while(c--)
    printf("+");
}

void subconst(int d,int c)
{
  to(d);
  while(c--)
    printf("-");
}

void settoconst(int d,int c)
{
  clear(d);
  addconst(d, c);
}

void multiplybyconst_z(int d,int s,int c)
{
  clear(d);
  to(s);
  printf("[");
  to(d);
  while(c--)
    printf("+");
  to(s);
  printf("-");
  printf("]");
}

void multiplybyconst(int d,int s,int c)
{
  copy(var_t2, s);
  multiplybyconst_z(d, s, c);
  copy_z(s, var_t2);
}

void inc(int d)
{
  addconst(d, 1);
}

void dec(int d)
{
  subconst(d, 1);
}

void _if_z(int a)
{
  to(a);
  printf("[");
}

void _endif_z(int a)
{
  clear(a);
  printf("]");
}

int main()
{
  // system vars
  var_t1  = def_var();
  var_t2  = def_var();
  // user
  int var_eax = def_var();
  int var_ebx = def_var();
  int var_ecx = def_var();
  int var_edx = def_var();

  settoconst(var_eax, 11);
  settoconst(var_ebx, 22);
  settoconst(var_ecx, 33);
  settoconst(var_edx, 44);

  printf("#");

  _if_z(var_eax);
    settoconst(var_ebx, 77);
  _endif_z(var_eax);

  printf("#");

} // main
