
istream_init:   pusha
                mov     ax, 3d00h
                int     21h
                mov     ihandle, ax
                call    istream_getbuf
                mov     icode, 0
                mov     ilen, 0
                popa
                ret

istream_done:   pusha
                mov     ah, 3eh
                mov     bx, ihandle
                int     21h
                popa
                ret

                ; output: jz eof

istream_getbuf: pusha
                mov     ah, 3fh
                mov     bx, ihandle
                lea     dx, ibuf
                mov     cx, ibuf_size
                int     21h
                mov     imax, ax
                mov     iptr, 0
                or      ax, ax
                popa
                ret

                ; output: al=byte
                ;         jz eof

istream_getbyte:push    bx
                mov     bx, iptr
                cmp     bx, imax
                jb      @@1
                call    istream_getbuf
                jz      @@2
                mov     bx, iptr
@@1:            mov     al, ibuf[bx]
                inc     iptr
@@2:            pop     bx
                ret

                ; output: jz eof
                ;         jc bit_1
                ;         jnc bit_0

istream_getbit: push    ax
                push    cx
                mov     cx, ilen
                or      cx, cx
                jnz     @@1
                call    istream_getbyte
                jz      @@2
                xor     ah, ah
                mov     cx, ilen
                shl     ax, cl
                or      icode, ax
                add     ilen, 8
@@1:            shr     icode, 1
                dec     ilen
                inc     cx
@@2:            pop     cx
                pop     ax
                ret

