/*
   SehMon  Exception Monitor  v1.02  Freeware  (x) 2004
*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#pragma hdrstop

#include "adjpriv2.c"

/* #define HOOKLIB_DEBUG */

#define HOOKLIB_WINNT
#define HOOKLIB_UNPROT_PAGES
#define HOOKLIB_USE_OWN_MALLOC
#define HOOKLIB_USE_OWN_FREE
#define HOOKLIB_USE_OWN_READ
#define HOOKLIB_USE_OWN_WRITE
#include "hooklib/hooklib.c"      /* API Splicing Library                    */
#include "sde/sde.c"              /* Subroutine Displacement Engine          */

/*********************** moveable stuff begin ********************************/

char* xStringTable[] =
{
  /* if SDE_SKIP_LOADLIBRARY is NOT specified, then:                         */
  /* entry #0 is list of DLL's to load via LoadLibraryA(),                   */
  /* each dll ends with ';' which is replaced with \0 in the injected code   */

  /* 0 */ "KERNEL32.DLL;USER32.DLL;MSVCRT.DLL;",

  /* other entries are user-defined */

  /* 1 */  "unused",

  /* 2 */
           "PID = 0x%08X = %d\n"
           "TID = 0x%08X\n"
           "module = %s\n"
           "\n"
           "ExceptionCode = 0x%08X = %s\n"
/*         "ExceptionFlags = 0x%08X = %s\n"
           "ExceptionRecord = 0x%08X\n"          */
           "ExceptionAddress = 0x%08X\n"
           "\n",

  /* 3 */  "EXCEPTION_DEBUG_EVENT",              /* 1 */
           "CREATE_THREAD_DEBUG_EVENT",
           "CREATE_PROCESS_DEBUG_EVENT",
           "EXIT_THREAD_DEBUG_EVENT",
           "EXIT_PROCESS_DEBUG_EVENT",
           "LOAD_DLL_DEBUG_EVENT",
           "UNLOAD_DLL_DEBUG_EVENT",
           "OUTPUT_DEBUG_STRING_EVENT",
  /* 11 */ "RIP_EVENT",                          /* 9 */
  /* 12 */ "EXCEPTION_GUARD_PAGE",               /* 80000001 */
           "EXCEPTION_DATATYPE_MISALIGNMENT",
           "EXCEPTION_BREAKPOINT",
  /* 15 */ "EXCEPTION_SINGLE_STEP",              /* 80000004 */
  /* 16 */ "EXCEPTION_ACCESS_VIOLATION",         /* C0000005 */
  /* 17 */ "EXCEPTION_IN_PAGE_ERROR",            /* C0000006 */
  /* 18 */ "EXCEPTION_INVALID_HANDLE",           /* C0000008 */
  /* 19 */ "EXCEPTION_ILLEGAL_INSTRUCTION",      /* C000001D */
  /* 20 */ "EXCEPTION_NONCONTINUABLE_EXCEPTION", /* C0000025 */
  /* 21 */ "EXCEPTION_INVALID_DISPOSITION",      /* C0000026 */
  /* 22 */ "EXCEPTION_ARRAY_BOUNDS_EXCEEDED",    /* C000008C */
           "EXCEPTION_FLT_DENORMAL_OPERAND",
           "EXCEPTION_FLT_DIVIDE_BY_ZERO",
           "EXCEPTION_FLT_INEXACT_RESULT",
           "EXCEPTION_FLT_INVALID_OPERATION",
           "EXCEPTION_FLT_OVERFLOW",
           "EXCEPTION_FLT_STACK_CHECK",
           "EXCEPTION_FLT_UNDERFLOW",
           "EXCEPTION_INT_DIVIDE_BY_ZERO",
           "EXCEPTION_INT_OVERFLOW",
           "EXCEPTION_PRIV_INSTRUCTION",         /* C0000096 */
  /* 33 */ "EXCEPTION_STACK_OVERFLOW",           /* C00000FD */
  /* 34 */ "UNKNOWN",
  /* 35 */ "EXCEPTION_NONCONTINUABLE",
  /* 36 */ "",

  /* 37 */ "ExceptionInformation: writing address 0x%08X\n"
           "\n",
  /* 38 */ "ExceptionInformation: reading address 0x%08X\n"
           "\n",

  /* 39 */ "CS:EIP = %04X:%08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "SS:ESP = %04X:%08X --> [%02X] %02X %02X %02X %02X %02X %02X %02X\n"
           "EFlags = %08X\n"
           "EAX = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X   # []=+0\n"
           "EBX = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "ECX = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "EDX = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "ESI = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "EDI = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "EBP = %08X --> %02X %02X %02X %02X [%02X] %02X %02X %02X\n"
           "\n"
           "FS:[0] = %08X (current SEH frame)\n"
           "[FS:[0]+0] = %08X (next SEH frame, -1=fuckup)\n"
           "[FS:[0]+4] = %08X (*** current SEH handler ***)\n"
           "[FS:[0]+8] = %08X\n"
           "\n",

  /* 40 */ "YES = debug, NO = ExitProcess, CANCEL = continue\n",

  /* 41 */ "SehMon: SEH catched",
  /* 42 */ "SehMon: EXCEPTION catched",

  /* last entry is NULL */
  NULL
};

void xStart() {}

char* get_ex_code_str(DWORD c)
{
  char** xStrTab;
  xStrTab = (char**)SDE_MAGIC_XSTRTAB;

#define CHECK_1(a,base)        if (c == a) return xStrTab[base];
#define CHECK_RANGE(a,b,base)  if ((c >= a) && (c <= b)) return xStrTab[c-a+base];

  CHECK_RANGE(1,9, 3)
  CHECK_RANGE(0x80000001,0x80000004, 12)
  CHECK_1(0xC0000005, 16)
  CHECK_1(0xC0000006, 17)
  CHECK_1(0xC0000008, 18)
  CHECK_1(0xC000001D, 19)
  CHECK_1(0xC0000025, 20)
  CHECK_1(0xC0000026, 21)
  CHECK_RANGE(0xC000008C,0xC0000096, 22)
  CHECK_1(0xC00000FD, 33)

  return xStrTab[34];

} /* get_ex_code_str */

BYTE GetByte(DWORD addr)
{
  DWORD NumRead;
  BYTE b;
  if (!ReadProcessMemory(GetCurrentProcess(),
                         (LPVOID)addr,
                         &b,
                         1,
                         &NumRead)) b = 0xFF;
  return b;
}

void __cdecl h_KiUserExceptionDispatcher(
                EXCEPTION_RECORD *EX,
                CONTEXT          *CTX
                )
{
  char** xStrTab;
  char module[256];
  char s[1024];
  unsigned long fs0, fs00, fs04, fs08;
  int res;
  MSGBOXPARAMS msgbox;

  xStrTab = (char**)SDE_MAGIC_XSTRTAB;

  GetModuleFileNameA(NULL, module, sizeof(module)-1);

  wsprintf(s, xStrTab[2],
    GetCurrentProcessId(),
    GetCurrentProcessId(),
    GetCurrentThreadId(),
    module,
    EX->ExceptionCode, get_ex_code_str(EX->ExceptionCode),
/*    EX->ExceptionFlags, xStrTab[EX->ExceptionFlags & EXCEPTION_NONCONTINUABLE ? 35 : 36],
    EX->ExceptionRecord,                             */
    EX->ExceptionAddress);

  if (EX->ExceptionCode == EXCEPTION_ACCESS_VIOLATION)
  {
    wsprintf(s+strlen(s),
      xStrTab[EX->ExceptionInformation[0] & 1 ? 37 : 38],
      EX->ExceptionInformation[1] );
  }

  fs00 = fs04 = fs08 = 0xffffffff;
  __asm {
         mov     eax, fs:[0]
         mov     fs0, eax
         cmp     eax, -1
         je      xx1
         mov     ecx, [eax+0]
         mov     fs00, ecx
         mov     ecx, [eax+4]
         mov     fs04, ecx
         mov     ecx, [eax+8]
         mov     fs08, ecx
    xx1:
  }

  wsprintf(s+strlen(s), xStrTab[39],
    CTX->SegCs, CTX->Eip,
      GetByte(CTX->Eip-4),
      GetByte(CTX->Eip-3),
      GetByte(CTX->Eip-2),
      GetByte(CTX->Eip-1),
      GetByte(CTX->Eip+0),
      GetByte(CTX->Eip+1),
      GetByte(CTX->Eip+2),
      GetByte(CTX->Eip+3),
    CTX->SegSs, CTX->Esp,
      GetByte(CTX->Esp+0),
      GetByte(CTX->Esp+1),
      GetByte(CTX->Esp+2),
      GetByte(CTX->Esp+3),
      GetByte(CTX->Esp+4),
      GetByte(CTX->Esp+5),
      GetByte(CTX->Esp+6),
      GetByte(CTX->Esp+7),
    CTX->EFlags,
    CTX->Eax,
      GetByte(CTX->Eax-4),
      GetByte(CTX->Eax-3),
      GetByte(CTX->Eax-2),
      GetByte(CTX->Eax-1),
      GetByte(CTX->Eax+0),
      GetByte(CTX->Eax+1),
      GetByte(CTX->Eax+2),
      GetByte(CTX->Eax+3),
    CTX->Ebx,
      GetByte(CTX->Ebx-4),
      GetByte(CTX->Ebx-3),
      GetByte(CTX->Ebx-2),
      GetByte(CTX->Ebx-1),
      GetByte(CTX->Ebx+0),
      GetByte(CTX->Ebx+1),
      GetByte(CTX->Ebx+2),
      GetByte(CTX->Ebx+3),
    CTX->Ecx,
      GetByte(CTX->Ecx-4),
      GetByte(CTX->Ecx-3),
      GetByte(CTX->Ecx-2),
      GetByte(CTX->Ecx-1),
      GetByte(CTX->Ecx+0),
      GetByte(CTX->Ecx+1),
      GetByte(CTX->Ecx+2),
      GetByte(CTX->Ecx+3),
    CTX->Edx,
      GetByte(CTX->Edx-4),
      GetByte(CTX->Edx-3),
      GetByte(CTX->Edx-2),
      GetByte(CTX->Edx-1),
      GetByte(CTX->Edx+0),
      GetByte(CTX->Edx+1),
      GetByte(CTX->Edx+2),
      GetByte(CTX->Edx+3),
    CTX->Esi,
      GetByte(CTX->Esi-4),
      GetByte(CTX->Esi-3),
      GetByte(CTX->Esi-2),
      GetByte(CTX->Esi-1),
      GetByte(CTX->Esi+0),
      GetByte(CTX->Esi+1),
      GetByte(CTX->Esi+2),
      GetByte(CTX->Esi+3),
    CTX->Edi,
      GetByte(CTX->Edi-4),
      GetByte(CTX->Edi-3),
      GetByte(CTX->Edi-2),
      GetByte(CTX->Edi-1),
      GetByte(CTX->Edi+0),
      GetByte(CTX->Edi+1),
      GetByte(CTX->Edi+2),
      GetByte(CTX->Edi+3),
    CTX->Ebp,
      GetByte(CTX->Ebp-4),
      GetByte(CTX->Ebp-3),
      GetByte(CTX->Ebp-2),
      GetByte(CTX->Ebp-1),
      GetByte(CTX->Ebp+0),
      GetByte(CTX->Ebp+1),
      GetByte(CTX->Ebp+2),
      GetByte(CTX->Ebp+3),

    fs0,
    fs00,
    fs04,
    fs08 );

  //OutputDebugStringA(xStrTab[40]);

  strcat(s, xStrTab[40]);

  msgbox.cbSize             = sizeof(msgbox);
  msgbox.hwndOwner          = NULL;
  msgbox.hInstance          = NULL;
  msgbox.lpszText           = s;
  msgbox.lpszCaption        = xStrTab[fs00!=0xFFFFFFFF?41:42];
  msgbox.dwStyle            = MB_ICONERROR | MB_YESNOCANCEL | MB_DEFBUTTON3;
  msgbox.lpszIcon           = IDI_EXCLAMATION;
  msgbox.dwContextHelpId    = 0;
  msgbox.lpfnMsgBoxCallback = NULL;
  msgbox.dwLanguageId       = LANG_ENGLISH;

  res = MessageBoxIndirect(&msgbox);

  if (res == IDYES) /* YES --> DEBUG */
  {
    __asm int 3;
    return;
  }

  if (res == IDNO)  /* NO --> EXIT */
  {
    ExitProcess(0);
  }

  /* CANCEL --> CONTINUE */

} /* h_KiUserExceptionDispatcher */

void __cdecl xEntry(unsigned long  injected_va,
                    unsigned long  injected_size,
                    char**         xStrTab,
                    unsigned char* binData,
                    unsigned long  binSize)
{

  /* do nothing here, but stub which called xEntry,
     will load DLLs from xStrTab[0] */

} /* xEntry */

void xEnd() {}

/*********************** moveable stuff end **********************************/

void help()
{
  printf("syntax:\n");
  printf("  sehmon [filename.exe]\n");
  printf("  sehmon --attach <pid>\n");
  printf("  sehmon --detach <pid> <hook-id>\n");
  exit(0);
}

int main(int argc, char** argv)
{
  static unsigned char buf[16384];
  unsigned long res, len, VA, entry, NumWritten, tid;
  STARTUPINFO startupinfo = {sizeof(STARTUPINFO),0,0,0,0,0,0,0,0,0,0,0,0};
  PROCESS_INFORMATION processinfo;
  void *hookHandle;
  HANDLE hRemoteThread;
  unsigned long mode, pid;
  char* filename;

  printf("SehMon  Exception Monitor  v1.02  Freeware  (x) 2004\n\n");

  if (GetVersion() & 0x80000000)
  {
    printf("win2K/XP required\n");
    exit(0);
  }

  adjcurpriv2();

  if ((argc == 3) && (!stricmp(argv[1], "--attach")))
  {
    mode = 2;
    pid = atoi(argv[2]);
  }
  else
  if ((argc == 4) && (!stricmp(argv[1], "--detach")))
  {
    mode = 3;
    pid = atoi(argv[2]);
    if (sscanf(argv[3], "%08X", &hookHandle) != 1) help();
  }
  else
  if (argc >= 2)
  {
    mode = 1;
    filename = strstr(GetCommandLineA(), argv[1]);
  }
  else
  {
    help();
  }

  if (mode == 1)
  {
    /* exec file */

    if (CreateProcess(NULL, argv[1], NULL, NULL, 0, CREATE_SUSPENDED, NULL, NULL,
                      &startupinfo, &processinfo) == 0)
    {
      printf("CreateProcess() error %d\n", GetLastError());
      exit(0);
    }
  }
  if ((mode == 2) || (mode == 3))
  {
    processinfo.hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pid);
    if (processinfo.hProcess == NULL)
    {
      printf("OpenProcess() error %d\n", GetLastError());
      exit(0);
    }
  }

  if (mode == 3)
  {
    if (!UninstallHook(hookHandle, processinfo.hProcess))
    {
      printf("InstallHook(1) error\n");
      exit(0);
    }

    printf("detached from PID=%d\n", pid);

    exit(0);
  } /* mode == 3 */

  /* allocate some memory within process' context */

  VA = (unsigned long) VirtualAllocEx( processinfo.hProcess,
                                       NULL,
                                       sizeof(buf),
                                       MEM_COMMIT,
                                       PAGE_EXECUTE_READWRITE );
  if (VA == 0)
  {
    printf("VirtualAllocEx() error %d\n", GetLastError());
    exit(0);
  }

  /* collect our garbage into buf[], prepare it to inject */

  res = Reassemble( (void*)&xStart,
                    (void*)&xEntry,
                    (void*)&xEnd,
                    xStringTable,
                    NULL,               /* no data */
                    0,                  /* no data */
                    buf,
                    sizeof(buf),
                    &len,
                    VA,
                    &entry,
                    0 );
  if (res == 0)
  {
    printf("Reassemble() error\n");
    exit(0);
  }

  /* inject the shit */

  if ( (WriteProcessMemory( processinfo.hProcess,
                            (void*)VA,
                            buf,
                            len,
                            &NumWritten ) == 0) || (NumWritten != len) )
  {
    printf("WriteProcessMemory() error %d\n", GetLastError());
    exit(0);
  }

  hookHandle = InstallHook(
     (void*)GetProcAddress(LoadLibrary("NTDLL.DLL"),     /* hook what    */
                           "KiUserExceptionDispatcher"),
                                                         /* replace with */
     (void*)(VA + (long)&h_KiUserExceptionDispatcher- (long)&xStart),
     0,                                                  /* flags        */
     0,                                                  /* nArgs        */
     NULL,                                               /* stubAddr     */
     0,                                                  /* stubSize     */
     processinfo.hProcess);                              /* hProcess     */

  if (!hookHandle)
  {
    printf("InstallHook(1) error\n");
    exit(0);
  }

  /* remotely call xEntry */

  hRemoteThread = CreateRemoteThread(
                      processinfo.hProcess, NULL, 0,
                      (LPTHREAD_START_ROUTINE)entry, 0, 0, &tid);
  if (!hRemoteThread)
  {
    printf("CreateRemoteThread() error %d\n", GetLastError());
    exit(0);
  }

  if (mode == 1)
  {

    /* resume our thread and wait until it is terminated */

    if (ResumeThread(hRemoteThread) == 0xFFFFFFFF)
    {
      printf("ResumeThtead() error %d\n", GetLastError());
      exit(0);
    }

    if (WaitForSingleObject(hRemoteThread, 1000) != WAIT_OBJECT_0)
    {
      printf("WaitForSingleObject() error\n");
      exit(0);
    }

    /* resume main thread */

    if (ResumeThread(processinfo.hThread) == 0xFFFFFFFF)
    {
      printf("ResumeThtead() error %d\n", GetLastError());
      exit(0);
    }

    printf("executed '%s', attached to PID=%d, hook-id=%08X\n",
      filename,
      processinfo.dwProcessId,
      hookHandle);

  } /* mode == 1 */

  if (mode == 2)
  {
    printf("attached to PID=%d, hook-id=%08X\n",
      pid,
      hookHandle);
  } /* mode == 2 */

  return 0;
} /* main() */
