
include                 thread.inc

callW                   macro   x
                        extern  x:PROC
                        call    x
                        endm

                        p386
                        model   flat
                        locals  __
                        jumps

                        .data

tid                     dd      ?
save_tcbptr             dd      ?
save_eip                dd      ?
save_cs                 dd      ?

                        .code
entry:
                        mov     eax, 93h        ; 4Fh/93h: i2E_xxGetCurrentThread
                        int     2Eh
                        mov     eax, [eax]      ; main thread control block
                        mov     save_tcbptr, eax

                        push    offset tid      ; *ThreadId
                        push    0               ; flags
                        push    12345678h       ; parameter
                        push    offset newthread; address
                        push    0               ; stack size. 0==same
                        push    0
                        callW   CreateThread

                        push    1               ; while threads switching
                        callW   Sleep

exit:                   push    -1
                        callW   ExitProcess

newthread:              pusha

                        mov     eax, save_tcbptr                ; main TCB
                        mov     eax, [eax].TCB_ClientPtr        ; registers

                        lea     ecx, ring0
                        xchg    ecx, [eax].Client_EIP           ; EIP
                        mov     save_eip, ecx

                        mov     ecx, 28h
                        xchg    cx, [eax].Client_CS             ; CS
                        mov     save_cs, ecx

                        popa
                        retn

ring0:                  pusha
                        push    ds es

                        mov     eax, ss
                        mov     ds, eax
                        mov     es, eax

                        in      al, 61h
                        xor     al, 3
                        out     61h, al

                        pop     es ds
                        popa

                        push    cs:save_cs
                        push    cs:save_eip
                        retf

                        end     entry
