
#include <windows.h>
#include <winsock2.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
//#include <assert.h>
#pragma hdrstop

#define C_MAX_SOCKET    64
#define LOG_FILE_LIMIT  4*1024*1024

#define WINAMPX_MUTEX_STR "WINAMPX_Mutex"
#define SERVICE_NAME    "WINAMPX"
#define SERVICE_DISPLAY "WinAmp Remote Control Server Service"

#define printf_err printf
#include "io.cpp"

int Active = 1;

SERVICE_STATUS_HANDLE StatusHandle;

SERVICE_TABLE_ENTRY ServiceTable[2] = {0};

SERVICE_STATUS ServiceStatus =
{
  SERVICE_WIN32_OWN_PROCESS+SERVICE_INTERACTIVE_PROCESS,
  SERVICE_RUNNING,
  SERVICE_ACCEPT_STOP,
  NO_ERROR,
  0,
  0,
  1000
};

void help()
{
  printf("server:\n");
  printf("  WINAMPX /install   -- install & run winampx server service (NT only)\n");
  printf("  WINAMPX /uninstall -- stop & uninstall winampx server service (NT only)\n");
  printf("  WINAMPX /run       -- run as server (the same as /install on NT)\n");
  printf("  define <cmd>=<value> within winampx.ini\n");
  printf("client:\n");
  printf("  WINAMPX /cmd <server_host|ip> <cmd> -- execute <value> on server's side\n");
  exit(0);
} // help()

extern "C++"
void __cdecl log(char* fmt, ...)
{
  va_list va;
  va_start(va, fmt);

  static char s[2048];
  SYSTEMTIME st;
  GetLocalTime(&st);
  sprintf(s,"%02u/%02u %02u:%02u:%02u  ",
    st.wDay,st.wMonth, st.wHour,st.wMinute,st.wSecond);
  vsnprintf(strchr(s,0), sizeof(s)-64, fmt, va);

  va_end(va);

  static char fn[1024];
  GetModuleFileName(NULL,fn,sizeof(fn)-1-16);
  if (strrchr(fn,'.'))
  {
    *strrchr(fn,'.') = 0;
    strcat(fn, ".log");
  }
  else
    strcpy(fn, "winampx.log");

  FILE*f = fopen(fn,"ab+");
  if (f != NULL)
  {
    if (filelength(fileno(f)) > LOG_FILE_LIMIT)
    {
      fclose(f);
      f = fopen(fn, "wb");
    }
    if (f)
    {
      fprintf(f, "%s", s);
      fclose(f);
    }
  }

} // log()

//#define match_str(s)   ((len == strlen(s)) && (memicmp(buf, s, len) == 0))

/*
void setvolume(DWORD vol)
{
  HMIXER hmx;
  mixerOpen(&hmx, 0,0,0,0);
  for(DWORD cid=0; cid<=100; cid++)
  {
    DWORD mxcd[8];
    mxcd[0] = 6*4;      // cbStruct
    mxcd[1] = cid;      // dwControlID
    mxcd[2] = 2;        // cChannels
    mxcd[3] = 0;        // cMultipleItems || HWND hwndOwner
    mxcd[4] = 4;        // cbDetails
    mxcd[5] = (DWORD)&mxcd[6];
    mxcd[6] = vol;
    mxcd[7] = vol;
    mixerSetControlDetails((HMIXEROBJ)hmx, (LPMIXERCONTROLDETAILS)&mxcd[0], 0);
  }
  mixerClose(hmx);
}
*/

char* process_packet(BYTE* buf, DWORD len, DWORD src_ip)
{
  static char ini[1024];
  GetModuleFileName(NULL,ini,sizeof(ini)-1);
  if (strrchr(ini,'.')) *strrchr(ini,'.')=0;
  strcat(ini, ".ini");

  char* src_ip_str = inet_ntoa(*(in_addr*)&src_ip);

  static char s[1024];
  s[0] = 0;

  int res = GetPrivateProfileString(
              "users",
              src_ip_str,
              "",
              s,
              sizeof(s)-1,
              ini);
  if ((res == 0) || (stricmp(s,"padonak")!=0))
  {
    log("ERROR:user [%s] not found in .ini=[%s]\n", src_ip_str, ini);
    return NULL;
  }

  if (!cmd_ok(buf,len))
  {
    log("ERROR:invalid packet\n");
    return "invalid packet";
  }

  log("cmd=[%s]\n", buf);

/*
  if ((len>=6+1+1)&&(memicmp(buf,"volume",5)==0))
  {
    DWORD vol=0;
    sscanf(&buf[6],"%i",&vol);
    log("changing volume to %i\n", vol);
    setvolume(vol);
    return "volume ok";
  }
*/

  res = GetPrivateProfileString(
              "commands",
              buf,
              "",
              s,
              sizeof(s)-1,
              ini);
  if (res==0)
  {
    log("ERROR:cmd not found in .ini\n");
    return "cmd not found";
  }
  log("value=[%s]\n", s);

  if ((s[0]=='0')&&(s[1]=='x')&&strchr(s,':'))
  {
    char* c = strchr(s,':'); *c++ = 0;
    HWND hWnd = FindWindow(c, NULL);
    if (hWnd == NULL)
    {
      printf("ERROR:cant find window\n");
      return "window not found";
    }
    DWORD n;
    sscanf(s+2, "%X", &n);
    PostMessage(hWnd, WM_COMMAND, n, NULL);
    return "msg ok";
  }
  else
  {
    if (WinExec(s, SW_SHOW) > 31)
      return "exec ok";
    else
      return "exec error";
  }
} // process_packet()

void winampx_server_main()
{
  log("WINAMPX server started\n");

  HANDLE hMutex = CreateMutex(NULL,1,WINAMPX_MUTEX_STR);
  if (hMutex == NULL)
  {
    log("WARNING:CreateMutex() error %i\n", GetLastError());
  }

  WSADATA WSAData;
  if (WSAStartup(MAKEWORD(1,1), &WSAData) != 0)
  {
    log("ERROR:WSAStartup() error %i\n", WSAGetLastError());
  }
  else
  {

    static BYTE computer[MAX_COMPUTERNAME_LENGTH+1];

    if (gethostname(&computer[0], sizeof(computer)) != 0)
    {
      log("ERROR:gethostname() error %i\n", WSAGetLastError());
    }
    else
    {

      hostent* he = gethostbyname(computer);

      if ((he == NULL) || (he->h_addrtype != AF_INET))
      {
        log("ERROR:gethostbyname() error %i\n", WSAGetLastError());
      }
      else
      {

        static SOCKET sock[C_MAX_SOCKET];
        int sock_count = 0;

        for (int i=0; he->h_addr_list[i]!=NULL; i++)
        {

          SOCKET s = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);

          if (s == INVALID_SOCKET)
          {
            log("ERROR:socket() error %i\n", WSAGetLastError());
          }
          else
          {

            DWORD optval = 1;
            if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char*)&optval, sizeof(optval)) != 0)
            {
              log("WARNING:setsockopt() error %i\n", WSAGetLastError());
            }

            DWORD nb1 = 1;
            if (ioctlsocket(s, FIONBIO, &nb1) != 0)
            {
              log("ERROR:ioctlsocket() error %i\n", WSAGetLastError());
              closesocket(s);
            }
            else
            {

              static sockaddr_in addr;
              addr.sin_family      = AF_INET;
              addr.sin_port        = htons(WINAMPX_SERVER_PORT);
              addr.sin_addr.s_addr = *(DWORD*)he->h_addr_list[i];

              if (bind(s, (sockaddr*)&addr, sizeof(addr)) != 0)
              {
                log("ERROR:bind() error %i\n", WSAGetLastError());
                closesocket(s);
              }
              else
              {
                log("listening on %s:%i\n", inet_ntoa(addr.sin_addr), WINAMPX_SERVER_PORT);
                sock[sock_count++] = s;
              }

            } // ioctlsocket()

          } // socket()

        }//for i

        if (sock_count == 0)
        {
          log("ERROR:no sockets created\n");
        }
        else
        {

          for(;;)
          {
            if (Active == 0)
            {
              log("terminating WINAMPX server\n");
              break;
            }

            static BYTE buf[MAX_MSG_LEN+1];

            for(int i=0; i<sock_count; i++)
            {
              sockaddr_in from;
              int fromlen = sizeof(from);
              int len = recvfrom(sock[i], buf, MAX_MSG_LEN, 0, (sockaddr*)&from, &fromlen);
              if ((len == 0) || (len == SOCKET_ERROR))
              {
                if (WSAGetLastError() != WSAEWOULDBLOCK)
                {
                  log("ERROR:recv() = %i, WSAGetLastError()=%i\n", len, WSAGetLastError());
                  sock[i] = sock[--sock_count];
                  break;
                }
              }
              else
              {
                log("packet from %s:%i, len=%i\n",
                  inet_ntoa(from.sin_addr),
                  ntohs(from.sin_port),
                  len);

                if (ntohs(from.sin_port) != WINAMPX_CLIENT_PORT)
                {
                  log("ERROR:wrong src port\n");
                }
                else
                {

                  char* res = process_packet(buf, len, from.sin_addr.s_addr);
                  if (res != NULL)
                  {
                    log("sending reply: [%s]\n", res);
                    int reslen = strlen(res)+1;
                    int len = sendto(sock[i], res, reslen, 0, (sockaddr*)&from, sizeof(from));
                    if (len != reslen)
                      log("ERROR:sendto() = %i, WSAGetLastError()=%i\n", len, WSAGetLastError());
                  }

                }
              }
            }

            if (sock_count==0)
            {
              log("ERROR:no more sockets\n");
              break;
            }

            Sleep(1000);
          }

          for(int i=0; i<sock_count; i++)
            closesocket(sock[i]);

        } // sock_count

      } // gethostbyname()

    } // gethostname()

    WSACleanup();

  } // WSAStartup()

  ServiceStatus.dwCurrentState = SERVICE_STOPPED;
  Active = 0;
  CloseHandle(hMutex);

  log("WINAMPX server stopped\n");

} // winampx_server_main()

void WINAPI Handler(DWORD fdwControl)
{
  switch (fdwControl)
  {
    case SERVICE_CONTROL_STOP:
      ServiceStatus.dwCurrentState = SERVICE_STOPPED;
      Active = 0;
      break;
    case SERVICE_CONTROL_INTERROGATE:
      break;
  } // switch
  SetServiceStatus(StatusHandle, &ServiceStatus);
}

void WINAPI ServiceMain(DWORD /* dwArgc */, LPTSTR /* *lpszArgv */)
{
  StatusHandle = RegisterServiceCtrlHandler(SERVICE_NAME, (LPHANDLER_FUNCTION)Handler);
  SetServiceStatus(StatusHandle, &ServiceStatus);
  winampx_server_main();
}

void on_service_start()
{
  ServiceTable[0].lpServiceName = SERVICE_NAME;
  ServiceTable[0].lpServiceProc = (LPSERVICE_MAIN_FUNCTION)ServiceMain;
  StartServiceCtrlDispatcher(ServiceTable);
}

int do_install()
{
  if ((GetVersion() & 0x80000000) != 0)
  {
    // win9X/ME

    printf("ERROR:win9X/ME doesnt supported yet\n");
    return 0;
  }
  else
  {
    // winNT/2K/XP

    SC_HANDLE SCM = OpenSCManager(0,0,SC_MANAGER_ALL_ACCESS);
    if (SCM == NULL)
    {
      printf("ERROR:OpenSCManager() error %i\n",GetLastError());
      return 0;
    }

    SC_HANDLE Service = OpenService(SCM, SERVICE_NAME, SERVICE_ALL_ACCESS);
    if (Service != NULL)
    {
      printf("WINAMPX service opened OK\n");
    }
    else
    {
      if (GetLastError() != ERROR_SERVICE_DOES_NOT_EXIST)
      {
        printf("ERROR:OpenService() error %i\n", GetLastError());
        CloseServiceHandle(SCM);
        return 0;
      }

    static char service_path[1024];
    GetModuleFileName(NULL, service_path, sizeof(service_path)-16);
    strcat(service_path, " /run");

    Service = CreateService(SCM,
                 SERVICE_NAME,
                 SERVICE_DISPLAY,
                 SERVICE_ALL_ACCESS,
                 SERVICE_WIN32_OWN_PROCESS+SERVICE_INTERACTIVE_PROCESS,
                 SERVICE_AUTO_START,
                 SERVICE_ERROR_IGNORE,
                 service_path,
                 0,0,0,0,0);
      if (Service == NULL)
      {
        printf("ERROR:CreateService() error %i\n", GetLastError());
        CloseServiceHandle(SCM);
        return 0;
      }

      printf("WINAMPX service created OK\n");
    }

    if (StartService(Service,0,0))
    {
      printf("WINAMPX service started OK\n");
    }
    else
    {
      if (GetLastError() == ERROR_SERVICE_ALREADY_RUNNING)
      {
        printf("WINAMPX service has been alredy installed and is running now\n");
      }
      else
      {
        printf("ERROR:StartService() error %i\n",GetLastError());
        CloseServiceHandle(Service);
        CloseServiceHandle(SCM);
        return 0;
      }
    }

    CloseServiceHandle(Service);
    CloseServiceHandle(SCM);

    return 1;
  }
} // do_install()

int do_uninstall()
{
  if ((GetVersion() & 0x80000000) != 0)
  {
    // win9X/ME

    printf("ERROR:win9X/ME doesnt supported yet\n");
    return 0;
  }
  else
  {
    // winNT/2K/XP

    SC_HANDLE SCM = OpenSCManager(0,0,SC_MANAGER_ALL_ACCESS);
    if (SCM == NULL)
    {
      printf("ERROR:OpenSCManager() error %i\n",GetLastError());
      return 0;
    }

    SC_HANDLE Service = OpenService(SCM, SERVICE_NAME, SERVICE_ALL_ACCESS);
    if (Service == NULL)
    {
      if (GetLastError() == ERROR_SERVICE_DOES_NOT_EXIST)
        printf("WINAMPX service has not been installed\n");
      else
        printf("ERROR:OpenService() error %i\n", GetLastError());
      CloseServiceHandle(SCM);
      return 0;
    }
    printf("WINAMPX service opened OK\n");

    SERVICE_STATUS SS;
    if (ControlService(Service, SERVICE_CONTROL_STOP, &SS)!=0)
    {
      printf("WINAMPX service stopped OK\n");
    }
    else
    {
      if (GetLastError() == ERROR_SERVICE_NOT_ACTIVE)
      {
        printf("WINAMPX service is not running\n");
      }
      else
      {
        printf("ERROR:ControlService(SERVICE_CONTROL_STOP) error %i\n", GetLastError());
        CloseServiceHandle(Service);
        CloseServiceHandle(SCM);
        return 0;
      }
    }

    if (DeleteService(Service)==0)
    {
      printf("ERROR:DeleteService() error %i\n", GetLastError());
      CloseServiceHandle(Service);
      CloseServiceHandle(SCM);
      return 0;
    }
    printf("WINAMPX service deleted ok\n");

    CloseServiceHandle(Service);
    CloseServiceHandle(SCM);

    return 1;
  }
} // do_uninstall()

int do_run()
{
  HANDLE hMutex = CreateMutex(NULL,0,WINAMPX_MUTEX_STR);
  if (GetLastError() != 0)
  {
    if (hMutex) CloseHandle(hMutex);
    printf("WINAMPX server is alredy running\n");
    return 0;
  }
  if (hMutex) CloseHandle(hMutex);

  if ((GetVersion() & 0x80000000) != 0)
  {
    FreeConsole();
    // win9X/ME
    winampx_server_main();
  }
  else
  {
    if (FreeConsole())
      return do_install(); // manual execution
    // service execution
    // winNT/2K/XP
    on_service_start();
    Sleep(INFINITE);
  }

  return 1;
}

void status()
{
  HANDLE hMutex = CreateMutex(NULL,0,WINAMPX_MUTEX_STR);
  printf("status: WINAMPX server is%s running\n",
    GetLastError() == 0 ? " NOT":"");
  if (hMutex)
    CloseHandle(hMutex);
}

void main(int argc, char* argv[])
{
  printf("WINAMPX (remote WINAMP control) (c) 2002\n");

  if ((argc==2)&&(!stricmp(argv[1],"/install")))
  {
    do_install();
    exit(0);
  }

  if ((argc==2)&&(!stricmp(argv[1],"/uninstall")))
  {
    do_uninstall();
    exit(0);
  }

  if ((argc==2)&&(!stricmp(argv[1],"/run")))
  {
    do_run();
    exit(0);
  }

  if ((argc==4)&&(!stricmp(argv[1],"/cmd"))&&(argv[3][0]!=0))
  {
    char* reply = do_cmd(argv[2], argv[3], 1);
    if (reply == NULL)
      printf("send failed\n");
    else
    {
      printf("server reply: [%s]\n", reply);
      free(reply);
    }
    exit(0);
  }

  status();

  help();

} // main

