
; CODEGEN 1.00 usage example
;
; ACTION:
; produce code (code32.bin) which will calculate an expression: c := a xor b;
; where a, b and c are DWORD-vars.

include                 ..\CODEGEN\codegen.equ

callW                   macro   x
                        extern  x:PROC
                        call    x
                        endm

                        p386
                        model   flat
                        locals  __

                        .data

;=== CODEGEN data ===
randseed                dd      ?
regfree                 dd      ?
;====================

buf_size                dd      ?               ; resulting code size
buf                     db      8192 dup (0)    ; resulting code

a                       dd      1               ; a
b                       dd      2               ; b
c                       dd      ?               ; c = a xor b

etgsize                 dd      ?            ; size of trash generated by ETG
testfile                db      'code32.bin',0  ; outfile

                        .code

start:
                        callW   GetTickCount    ; randomize
                        xor     randseed, eax

                        mov     regfree, 11001111b  ; edi/esi/ebx/edx/ecx/eax
                        lea     edi, buf

                        call3   cmd_v_v, c_mov, <offset c>, <offset a>; c = a
                        call3   cmd_v_v, c_xor, <offset c>, <offset b>; c ^= b
                        mov     al, 0C3h        ; ret
                        stosb

                        sub     edi, offset buf  ; calc buf size
                        mov     buf_size, edi

                        call    near ptr buf    ; call generated code

                        mov     eax, a          ; check if c == a ^ b
                        xor     eax, b
                        cmp     eax, c
                        jne     $               ; hangup if error

                        lea     edx, testfile   ; save generated code
                        call    fcreate
                        xchg    ebx, eax
                        lea     edx, buf
                        mov     ecx, buf_size
                        call    fwrite
                        call    fclose

                        push    -1              ; exit 2 md
                        callW   ExitProcess


; called after each instruction is stored into EDI. use trash generator here
endcmd:

;                       mov     al, 90h
;                       stosb

                        push    offset my_random; external subroutine: rnd
                        push    edi             ; ptr to output buffer
                        push    1024            ; max size of buffer
                        push    3               ; max number of commands
                        push    offset etgsize  ; ptr to generated bufsize
                        push    regfree         ; REG_xxx (dest)
                        push    REG_ALL         ; REG_xxx (src)
                        push    ETG_ALL-ETG_SEG ; ETG_xxx (cmd)
                        call    etg_engine
                        add     edi, etgsize

                        retn

include                 etg.inc                 ; ETG
include                 fioexlow.inc            ; file io
include                 ..\CODEGEN\codegen.inc  ; CODEGEN

                        end     start
