
; signature verification example

callW                   macro   x
                        extern  x:PROC
                        call    x
                        endm

                        p386
                        model   flat
                        locals  __
                        jumps

                        .data

; 1. this is plugin's code
datafile                label   byte
  db 'super-puper destructive plugin (x) http://z0mbie.cjb.net'
datafile_size           equ     $-datafile

; 2. this is plugin's signature, placed before or after plugin's code
sign                    db      '/:jmޒN"ު'

hash                    db      16 dup (?)

                        .code
start:

; 1. rsa_decrypt signature, using public key
                        lea     edi, sign   ; ptr to signature, 16 bytes
                        lea     esi, rsa_n  ; ptr to public key, 16 bytes
                        mov     eax, 50003  ; predefined low exponent
                        call    modexp55    ; [EDI] = ([EDI] ^ EAX) % [ESI]

; 2. calculate hash of the plugin's code
                        lea     esi, datafile      ; ptr to data
                        mov     ecx, datafile_size ; data size, in bytes
                        lea     edi, hash          ; ptr to hash, 16 bytes
                        call    hash127

; 3. compare calculated hash with decrypted one
                        lea     esi, hash
                        lea     edi, sign
                        mov     ecx, 16
                        rep     cmpsb
                        jne     __exit

; load & executed new plugin
                        push    -1              ; beep if OK
                        callW   MessageBeep

__exit:                 push    -1
                        callW   ExitProcess

x1_start:

;----------------------------------------------------------------------------
; stuff to verify signed data:
include                 ..\rsalib55.inc         ; modexp subroutine
include                 ..\hash127.inc          ; hash subroutine
include                 ..\KEY\SIGN\public.inc  ; public RSA key
;----------------------------------------------------------------------------

x1_size                 equ     $-x1_start

db 13,10,'----------------------',13,10
db x1_size/1000 mod 10+'0'
db x1_size/ 100 mod 10+'0'
db x1_size/  10 mod 10+'0'
db x1_size/   1 mod 10+'0'
db ' bytes',13,10
db 13,10,'----------------------',13,10

                        end     start
